/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model.generated;

import com.fusesource.rider.commons.properties.ListPropertyDescriptor;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.ExpressionPropertyDescriptor;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.generated.Messages;
import com.fusesource.rider.model.util.Objects;
import java.util.List;
import java.util.Map;
import org.apache.camel.model.CatchDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class Catch
extends AbstractNode {
    public static final String PROPERTY_EXCEPTIONS = "Catch.Exceptions";
    public static final String PROPERTY_HANDLED = "Catch.Handled";
    private List exceptions;
    private ExpressionDefinition handled;

    public Catch() {
    }

    public Catch(CatchDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "generic.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "catchEIP";
    }

    @Override
    public String getCategoryName() {
        return "Control Flow";
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List exceptions) {
        List oldValue = this.exceptions;
        this.exceptions = exceptions;
        this.firePropertyChange(PROPERTY_EXCEPTIONS, oldValue, exceptions);
    }

    public ExpressionDefinition getHandled() {
        return this.handled;
    }

    public void setHandled(ExpressionDefinition handled) {
        ExpressionDefinition oldValue = this.handled;
        this.handled = handled;
        this.firePropertyChange(PROPERTY_HANDLED, oldValue, handled);
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        ListPropertyDescriptor descExceptions = new ListPropertyDescriptor((Object)PROPERTY_EXCEPTIONS, Messages.propertyLabelCatchExceptions);
        ExpressionPropertyDescriptor descHandled = new ExpressionPropertyDescriptor(PROPERTY_HANDLED, Messages.propertyLabelCatchHandled);
        descriptors.put(PROPERTY_EXCEPTIONS, (PropertyDescriptor)descExceptions);
        descriptors.put(PROPERTY_HANDLED, descHandled);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_EXCEPTIONS.equals(id)) {
            this.setExceptions(Objects.convertTo(value, List.class));
        } else if (PROPERTY_HANDLED.equals(id)) {
            this.setHandled(Objects.convertTo(value, ExpressionDefinition.class));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_EXCEPTIONS.equals(id)) {
            return this.getExceptions();
        }
        if (PROPERTY_HANDLED.equals(id)) {
            return this.getHandled();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        CatchDefinition answer = new CatchDefinition();
        answer.setExceptions(this.toXmlPropertyValue(PROPERTY_EXCEPTIONS, this.getExceptions()));
        Objects.setField(answer, "handled", this.toXmlPropertyValue(PROPERTY_HANDLED, this.getHandled()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return CatchDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof CatchDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof CatchDefinition. Was " + processor.getClass().getName());
        }
        CatchDefinition node = (CatchDefinition)processor;
        this.setExceptions(node.getExceptions());
        Objects.setField((Object)this, "handled", node.getHandled());
    }
}

