/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model.generated;

import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.generated.Messages;
import com.fusesource.rider.model.util.Objects;
import java.util.Map;
import org.apache.camel.model.ConvertBodyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ConvertBody
extends AbstractNode {
    public static final String PROPERTY_TYPE = "ConvertBody.Type";
    public static final String PROPERTY_CHARSET = "ConvertBody.Charset";
    private String type;
    private String charset;

    public ConvertBody() {
    }

    public ConvertBody(ConvertBodyDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "convertBody.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "convertEIP";
    }

    @Override
    public String getCategoryName() {
        return "Transformation";
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        String oldValue = this.type;
        this.type = type;
        this.firePropertyChange(PROPERTY_TYPE, oldValue, type);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        String oldValue = this.charset;
        this.charset = charset;
        this.firePropertyChange(PROPERTY_CHARSET, oldValue, charset);
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor descType = new TextPropertyDescriptor((Object)PROPERTY_TYPE, Messages.propertyLabelConvertBodyType);
        TextPropertyDescriptor descCharset = new TextPropertyDescriptor((Object)PROPERTY_CHARSET, Messages.propertyLabelConvertBodyCharset);
        descriptors.put(PROPERTY_TYPE, (PropertyDescriptor)descType);
        descriptors.put(PROPERTY_CHARSET, (PropertyDescriptor)descCharset);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_TYPE.equals(id)) {
            this.setType(Objects.convertTo(value, String.class));
        } else if (PROPERTY_CHARSET.equals(id)) {
            this.setCharset(Objects.convertTo(value, String.class));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_TYPE.equals(id)) {
            return this.getType();
        }
        if (PROPERTY_CHARSET.equals(id)) {
            return this.getCharset();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        ConvertBodyDefinition answer = new ConvertBodyDefinition();
        answer.setType(this.toXmlPropertyValue(PROPERTY_TYPE, this.getType()));
        answer.setCharset(this.toXmlPropertyValue(PROPERTY_CHARSET, this.getCharset()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return ConvertBodyDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof ConvertBodyDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof ConvertBodyDefinition. Was " + processor.getClass().getName());
        }
        ConvertBodyDefinition node = (ConvertBodyDefinition)processor;
        this.setType(node.getType());
        this.setCharset(node.getCharset());
    }
}

