/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model.generated;

import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.generated.Messages;
import com.fusesource.rider.model.util.Objects;
import java.util.Map;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class Enrich
extends AbstractNode {
    public static final String PROPERTY_RESOURCEURI = "Enrich.ResourceUri";
    public static final String PROPERTY_AGGREGATIONSTRATEGYREF = "Enrich.AggregationStrategyRef";
    private String resourceUri;
    private String aggregationStrategyRef;

    public Enrich() {
    }

    public Enrich(EnrichDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "enrich.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "enrichEIP";
    }

    @Override
    public String getCategoryName() {
        return "Transformation";
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        String oldValue = this.resourceUri;
        this.resourceUri = resourceUri;
        this.firePropertyChange(PROPERTY_RESOURCEURI, oldValue, resourceUri);
    }

    public String getAggregationStrategyRef() {
        return this.aggregationStrategyRef;
    }

    public void setAggregationStrategyRef(String aggregationStrategyRef) {
        String oldValue = this.aggregationStrategyRef;
        this.aggregationStrategyRef = aggregationStrategyRef;
        this.firePropertyChange(PROPERTY_AGGREGATIONSTRATEGYREF, oldValue, aggregationStrategyRef);
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor descResourceUri = new TextPropertyDescriptor((Object)PROPERTY_RESOURCEURI, Messages.propertyLabelEnrichResourceUri);
        TextPropertyDescriptor descAggregationStrategyRef = new TextPropertyDescriptor((Object)PROPERTY_AGGREGATIONSTRATEGYREF, Messages.propertyLabelEnrichAggregationStrategyRef);
        descriptors.put(PROPERTY_RESOURCEURI, (PropertyDescriptor)descResourceUri);
        descriptors.put(PROPERTY_AGGREGATIONSTRATEGYREF, (PropertyDescriptor)descAggregationStrategyRef);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_RESOURCEURI.equals(id)) {
            this.setResourceUri(Objects.convertTo(value, String.class));
        } else if (PROPERTY_AGGREGATIONSTRATEGYREF.equals(id)) {
            this.setAggregationStrategyRef(Objects.convertTo(value, String.class));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_RESOURCEURI.equals(id)) {
            return this.getResourceUri();
        }
        if (PROPERTY_AGGREGATIONSTRATEGYREF.equals(id)) {
            return this.getAggregationStrategyRef();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        EnrichDefinition answer = new EnrichDefinition();
        answer.setResourceUri(this.toXmlPropertyValue(PROPERTY_RESOURCEURI, this.getResourceUri()));
        answer.setAggregationStrategyRef(this.toXmlPropertyValue(PROPERTY_AGGREGATIONSTRATEGYREF, this.getAggregationStrategyRef()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return EnrichDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof EnrichDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof EnrichDefinition. Was " + processor.getClass().getName());
        }
        EnrichDefinition node = (EnrichDefinition)processor;
        this.setResourceUri(node.getResourceUri());
        this.setAggregationStrategyRef(node.getAggregationStrategyRef());
    }
}

