/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model.generated;

import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.generated.Messages;
import com.fusesource.rider.model.util.Objects;
import java.util.Map;
import org.apache.camel.model.InOutDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class InOut
extends AbstractNode {
    public static final String PROPERTY_URI = "InOut.Uri";
    private String uri;

    public InOut() {
    }

    public InOut(InOutDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "transform.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "inOutEIP";
    }

    @Override
    public String getCategoryName() {
        return "Transformation";
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        String oldValue = this.uri;
        this.uri = uri;
        this.firePropertyChange(PROPERTY_URI, oldValue, uri);
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor descUri = new TextPropertyDescriptor((Object)PROPERTY_URI, Messages.propertyLabelInOutUri);
        descriptors.put(PROPERTY_URI, (PropertyDescriptor)descUri);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_URI.equals(id)) {
            this.setUri(Objects.convertTo(value, String.class));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_URI.equals(id)) {
            return this.getUri();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        InOutDefinition answer = new InOutDefinition();
        answer.setUri(this.toXmlPropertyValue(PROPERTY_URI, this.getUri()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return InOutDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof InOutDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof InOutDefinition. Was " + processor.getClass().getName());
        }
        InOutDefinition node = (InOutDefinition)processor;
        this.setUri(node.getUri());
    }
}

