/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model.generated;

import com.fusesource.rider.commons.properties.ComplexUnionPropertyDescriptor;
import com.fusesource.rider.commons.properties.UnionTypeValue;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.generated.Messages;
import com.fusesource.rider.model.util.Objects;
import java.util.Map;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.LoadBalancerDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.loadbalancer.CustomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.FailoverLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RandomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.StickyLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.TopicLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.WeightedLoadBalancerDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class LoadBalance
extends AbstractNode {
    public static final String PROPERTY_REF = "LoadBalance.Ref";
    public static final String PROPERTY_LOADBALANCERTYPE = "LoadBalance.LoadBalancerType";
    private String ref;
    private LoadBalancerDefinition loadBalancerType;

    public LoadBalance() {
    }

    public LoadBalance(LoadBalanceDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "loadBalance.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "loadBalanceEIP";
    }

    @Override
    public String getCategoryName() {
        return "Routing";
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        String oldValue = this.ref;
        this.ref = ref;
        this.firePropertyChange(PROPERTY_REF, oldValue, ref);
    }

    public LoadBalancerDefinition getLoadBalancerType() {
        return this.loadBalancerType;
    }

    public void setLoadBalancerType(LoadBalancerDefinition loadBalancerType) {
        LoadBalancerDefinition oldValue = this.loadBalancerType;
        this.loadBalancerType = loadBalancerType;
        this.firePropertyChange(PROPERTY_LOADBALANCERTYPE, oldValue, loadBalancerType);
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor descRef = new TextPropertyDescriptor((Object)PROPERTY_REF, Messages.propertyLabelLoadBalanceRef);
        ComplexUnionPropertyDescriptor descLoadBalancerType = new ComplexUnionPropertyDescriptor((Object)PROPERTY_LOADBALANCERTYPE, Messages.propertyLabelLoadBalanceLoadBalancerType, LoadBalancerDefinition.class, new UnionTypeValue[]{new UnionTypeValue("failover", FailoverLoadBalancerDefinition.class), new UnionTypeValue("random", RandomLoadBalancerDefinition.class), new UnionTypeValue("custom", CustomLoadBalancerDefinition.class), new UnionTypeValue("roundRobin", RoundRobinLoadBalancerDefinition.class), new UnionTypeValue("sticky", StickyLoadBalancerDefinition.class), new UnionTypeValue("topic", TopicLoadBalancerDefinition.class), new UnionTypeValue("weighted", WeightedLoadBalancerDefinition.class)});
        descriptors.put(PROPERTY_REF, (PropertyDescriptor)descRef);
        descriptors.put(PROPERTY_LOADBALANCERTYPE, (PropertyDescriptor)descLoadBalancerType);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_REF.equals(id)) {
            this.setRef(Objects.convertTo(value, String.class));
        } else if (PROPERTY_LOADBALANCERTYPE.equals(id)) {
            this.setLoadBalancerType(Objects.convertTo(value, LoadBalancerDefinition.class));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_REF.equals(id)) {
            return this.getRef();
        }
        if (PROPERTY_LOADBALANCERTYPE.equals(id)) {
            return this.getLoadBalancerType();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        LoadBalanceDefinition answer = new LoadBalanceDefinition();
        answer.setRef(this.toXmlPropertyValue(PROPERTY_REF, this.getRef()));
        answer.setLoadBalancerType(this.toXmlPropertyValue(PROPERTY_LOADBALANCERTYPE, this.getLoadBalancerType()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return LoadBalanceDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof LoadBalanceDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof LoadBalanceDefinition. Was " + processor.getClass().getName());
        }
        LoadBalanceDefinition node = (LoadBalanceDefinition)processor;
        this.setRef(node.getRef());
        this.setLoadBalancerType(node.getLoadBalancerType());
    }
}

