/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model.generated;

import com.fusesource.rider.commons.properties.EnumPropertyDescriptor;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.generated.Messages;
import com.fusesource.rider.model.util.Objects;
import java.util.Map;
import org.apache.camel.LoggingLevel;
import org.apache.camel.model.LogDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class Log
extends AbstractNode {
    public static final String PROPERTY_MESSAGE = "Log.Message";
    public static final String PROPERTY_LOGNAME = "Log.LogName";
    public static final String PROPERTY_MARKER = "Log.Marker";
    public static final String PROPERTY_LOGGINGLEVEL = "Log.LoggingLevel";
    private String message;
    private String logName;
    private String marker;
    private LoggingLevel loggingLevel;

    public Log() {
    }

    public Log(LogDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "endpoint.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "logEIP";
    }

    @Override
    public String getCategoryName() {
        return "Endpoints";
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        String oldValue = this.message;
        this.message = message;
        this.firePropertyChange(PROPERTY_MESSAGE, oldValue, message);
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        String oldValue = this.logName;
        this.logName = logName;
        this.firePropertyChange(PROPERTY_LOGNAME, oldValue, logName);
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        String oldValue = this.marker;
        this.marker = marker;
        this.firePropertyChange(PROPERTY_MARKER, oldValue, marker);
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(LoggingLevel loggingLevel) {
        LoggingLevel oldValue = this.loggingLevel;
        this.loggingLevel = loggingLevel;
        this.firePropertyChange(PROPERTY_LOGGINGLEVEL, oldValue, loggingLevel);
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor descMessage = new TextPropertyDescriptor((Object)PROPERTY_MESSAGE, Messages.propertyLabelLogMessage);
        TextPropertyDescriptor descLogName = new TextPropertyDescriptor((Object)PROPERTY_LOGNAME, Messages.propertyLabelLogLogName);
        TextPropertyDescriptor descMarker = new TextPropertyDescriptor((Object)PROPERTY_MARKER, Messages.propertyLabelLogMarker);
        EnumPropertyDescriptor descLoggingLevel = new EnumPropertyDescriptor((Object)PROPERTY_LOGGINGLEVEL, Messages.propertyLabelLogLoggingLevel, LoggingLevel.class);
        descriptors.put(PROPERTY_MESSAGE, (PropertyDescriptor)descMessage);
        descriptors.put(PROPERTY_LOGNAME, (PropertyDescriptor)descLogName);
        descriptors.put(PROPERTY_MARKER, (PropertyDescriptor)descMarker);
        descriptors.put(PROPERTY_LOGGINGLEVEL, (PropertyDescriptor)descLoggingLevel);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_MESSAGE.equals(id)) {
            this.setMessage(Objects.convertTo(value, String.class));
        } else if (PROPERTY_LOGNAME.equals(id)) {
            this.setLogName(Objects.convertTo(value, String.class));
        } else if (PROPERTY_MARKER.equals(id)) {
            this.setMarker(Objects.convertTo(value, String.class));
        } else if (PROPERTY_LOGGINGLEVEL.equals(id)) {
            this.setLoggingLevel(Objects.convertTo(value, LoggingLevel.class));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_MESSAGE.equals(id)) {
            return this.getMessage();
        }
        if (PROPERTY_LOGNAME.equals(id)) {
            return this.getLogName();
        }
        if (PROPERTY_MARKER.equals(id)) {
            return this.getMarker();
        }
        if (PROPERTY_LOGGINGLEVEL.equals(id)) {
            return this.getLoggingLevel();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        LogDefinition answer = new LogDefinition();
        answer.setMessage(this.toXmlPropertyValue(PROPERTY_MESSAGE, this.getMessage()));
        answer.setLogName(this.toXmlPropertyValue(PROPERTY_LOGNAME, this.getLogName()));
        answer.setMarker(this.toXmlPropertyValue(PROPERTY_MARKER, this.getMarker()));
        answer.setLoggingLevel(this.toXmlPropertyValue(PROPERTY_LOGGINGLEVEL, this.getLoggingLevel()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return LogDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof LogDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof LogDefinition. Was " + processor.getClass().getName());
        }
        LogDefinition node = (LogDefinition)processor;
        this.setMessage(node.getMessage());
        this.setLogName(node.getLogName());
        this.setMarker(node.getMarker());
        this.setLoggingLevel(node.getLoggingLevel());
    }
}

