/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model.generated;

import com.fusesource.rider.commons.properties.BooleanPropertyDescriptor;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.ExpressionPropertyDescriptor;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.generated.Messages;
import com.fusesource.rider.model.util.Objects;
import java.util.Map;
import org.apache.camel.model.LoopDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class Loop
extends AbstractNode {
    public static final String PROPERTY_EXPRESSION = "Loop.Expression";
    public static final String PROPERTY_COPY = "Loop.Copy";
    private ExpressionDefinition expression;
    private Boolean copy;

    public Loop() {
    }

    public Loop(LoopDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "generic.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "loopEIP";
    }

    @Override
    public String getCategoryName() {
        return "Control Flow";
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        ExpressionDefinition oldValue = this.expression;
        this.expression = expression;
        this.firePropertyChange(PROPERTY_EXPRESSION, oldValue, expression);
    }

    public Boolean getCopy() {
        return this.copy;
    }

    public void setCopy(Boolean copy) {
        Boolean oldValue = this.copy;
        this.copy = copy;
        this.firePropertyChange(PROPERTY_COPY, oldValue, copy);
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        ExpressionPropertyDescriptor descExpression = new ExpressionPropertyDescriptor(PROPERTY_EXPRESSION, Messages.propertyLabelLoopExpression);
        BooleanPropertyDescriptor descCopy = new BooleanPropertyDescriptor((Object)PROPERTY_COPY, Messages.propertyLabelLoopCopy);
        descriptors.put(PROPERTY_EXPRESSION, descExpression);
        descriptors.put(PROPERTY_COPY, (PropertyDescriptor)descCopy);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_EXPRESSION.equals(id)) {
            this.setExpression(Objects.convertTo(value, ExpressionDefinition.class));
        } else if (PROPERTY_COPY.equals(id)) {
            this.setCopy(Objects.convertTo(value, Boolean.class));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_EXPRESSION.equals(id)) {
            return this.getExpression();
        }
        if (PROPERTY_COPY.equals(id)) {
            return this.getCopy();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        LoopDefinition answer = new LoopDefinition();
        answer.setExpression(this.toXmlPropertyValue(PROPERTY_EXPRESSION, this.getExpression()));
        answer.setCopy(this.toXmlPropertyValue(PROPERTY_COPY, this.getCopy()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return LoopDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof LoopDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof LoopDefinition. Was " + processor.getClass().getName());
        }
        LoopDefinition node = (LoopDefinition)processor;
        this.setExpression(node.getExpression());
        this.setCopy(node.getCopy());
    }
}

