/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model.generated;

import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.generated.Messages;
import com.fusesource.rider.model.util.Objects;
import java.util.Map;
import org.apache.camel.model.PollEnrichDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class PollEnrich
extends AbstractNode {
    public static final String PROPERTY_RESOURCEURI = "PollEnrich.ResourceUri";
    public static final String PROPERTY_AGGREGATIONSTRATEGYREF = "PollEnrich.AggregationStrategyRef";
    public static final String PROPERTY_TIMEOUT = "PollEnrich.Timeout";
    private String resourceUri;
    private String aggregationStrategyRef;
    private Long timeout;

    public PollEnrich() {
    }

    public PollEnrich(PollEnrichDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "pollEnrich.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "pollEnrichEIP";
    }

    @Override
    public String getCategoryName() {
        return "Transformation";
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        String oldValue = this.resourceUri;
        this.resourceUri = resourceUri;
        this.firePropertyChange(PROPERTY_RESOURCEURI, oldValue, resourceUri);
    }

    public String getAggregationStrategyRef() {
        return this.aggregationStrategyRef;
    }

    public void setAggregationStrategyRef(String aggregationStrategyRef) {
        String oldValue = this.aggregationStrategyRef;
        this.aggregationStrategyRef = aggregationStrategyRef;
        this.firePropertyChange(PROPERTY_AGGREGATIONSTRATEGYREF, oldValue, aggregationStrategyRef);
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        Long oldValue = this.timeout;
        this.timeout = timeout;
        this.firePropertyChange(PROPERTY_TIMEOUT, oldValue, timeout);
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor descResourceUri = new TextPropertyDescriptor((Object)PROPERTY_RESOURCEURI, Messages.propertyLabelPollEnrichResourceUri);
        TextPropertyDescriptor descAggregationStrategyRef = new TextPropertyDescriptor((Object)PROPERTY_AGGREGATIONSTRATEGYREF, Messages.propertyLabelPollEnrichAggregationStrategyRef);
        TextPropertyDescriptor descTimeout = new TextPropertyDescriptor((Object)PROPERTY_TIMEOUT, Messages.propertyLabelPollEnrichTimeout);
        descriptors.put(PROPERTY_RESOURCEURI, (PropertyDescriptor)descResourceUri);
        descriptors.put(PROPERTY_AGGREGATIONSTRATEGYREF, (PropertyDescriptor)descAggregationStrategyRef);
        descriptors.put(PROPERTY_TIMEOUT, (PropertyDescriptor)descTimeout);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_RESOURCEURI.equals(id)) {
            this.setResourceUri(Objects.convertTo(value, String.class));
        } else if (PROPERTY_AGGREGATIONSTRATEGYREF.equals(id)) {
            this.setAggregationStrategyRef(Objects.convertTo(value, String.class));
        } else if (PROPERTY_TIMEOUT.equals(id)) {
            this.setTimeout(Objects.convertTo(value, Long.class));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_RESOURCEURI.equals(id)) {
            return this.getResourceUri();
        }
        if (PROPERTY_AGGREGATIONSTRATEGYREF.equals(id)) {
            return this.getAggregationStrategyRef();
        }
        if (PROPERTY_TIMEOUT.equals(id)) {
            return this.getTimeout();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        PollEnrichDefinition answer = new PollEnrichDefinition();
        answer.setResourceUri(this.toXmlPropertyValue(PROPERTY_RESOURCEURI, this.getResourceUri()));
        answer.setAggregationStrategyRef(this.toXmlPropertyValue(PROPERTY_AGGREGATIONSTRATEGYREF, this.getAggregationStrategyRef()));
        answer.setTimeout(this.toXmlPropertyValue(PROPERTY_TIMEOUT, this.getTimeout()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return PollEnrichDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof PollEnrichDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof PollEnrichDefinition. Was " + processor.getClass().getName());
        }
        PollEnrichDefinition node = (PollEnrichDefinition)processor;
        this.setResourceUri(node.getResourceUri());
        this.setAggregationStrategyRef(node.getAggregationStrategyRef());
        this.setTimeout(node.getTimeout());
    }
}

