/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model.generated;

import com.fusesource.rider.commons.properties.BooleanPropertyDescriptor;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.generated.Messages;
import com.fusesource.rider.model.util.Objects;
import java.util.Map;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RollbackDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class Rollback
extends AbstractNode {
    public static final String PROPERTY_MESSAGE = "Rollback.Message";
    public static final String PROPERTY_MARKROLLBACKONLY = "Rollback.MarkRollbackOnly";
    public static final String PROPERTY_MARKROLLBACKONLYLAST = "Rollback.MarkRollbackOnlyLast";
    private String message;
    private Boolean markRollbackOnly;
    private Boolean markRollbackOnlyLast;

    public Rollback() {
    }

    public Rollback(RollbackDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "generic.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "rolbackNode";
    }

    @Override
    public String getCategoryName() {
        return "Control Flow";
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        String oldValue = this.message;
        this.message = message;
        this.firePropertyChange(PROPERTY_MESSAGE, oldValue, message);
    }

    public Boolean getMarkRollbackOnly() {
        return this.markRollbackOnly;
    }

    public void setMarkRollbackOnly(Boolean markRollbackOnly) {
        Boolean oldValue = this.markRollbackOnly;
        this.markRollbackOnly = markRollbackOnly;
        this.firePropertyChange(PROPERTY_MARKROLLBACKONLY, oldValue, markRollbackOnly);
    }

    public Boolean getMarkRollbackOnlyLast() {
        return this.markRollbackOnlyLast;
    }

    public void setMarkRollbackOnlyLast(Boolean markRollbackOnlyLast) {
        Boolean oldValue = this.markRollbackOnlyLast;
        this.markRollbackOnlyLast = markRollbackOnlyLast;
        this.firePropertyChange(PROPERTY_MARKROLLBACKONLYLAST, oldValue, markRollbackOnlyLast);
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor descMessage = new TextPropertyDescriptor((Object)PROPERTY_MESSAGE, Messages.propertyLabelRollbackMessage);
        BooleanPropertyDescriptor descMarkRollbackOnly = new BooleanPropertyDescriptor((Object)PROPERTY_MARKROLLBACKONLY, Messages.propertyLabelRollbackMarkRollbackOnly);
        BooleanPropertyDescriptor descMarkRollbackOnlyLast = new BooleanPropertyDescriptor((Object)PROPERTY_MARKROLLBACKONLYLAST, Messages.propertyLabelRollbackMarkRollbackOnlyLast);
        descriptors.put(PROPERTY_MESSAGE, (PropertyDescriptor)descMessage);
        descriptors.put(PROPERTY_MARKROLLBACKONLY, (PropertyDescriptor)descMarkRollbackOnly);
        descriptors.put(PROPERTY_MARKROLLBACKONLYLAST, (PropertyDescriptor)descMarkRollbackOnlyLast);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_MESSAGE.equals(id)) {
            this.setMessage(Objects.convertTo(value, String.class));
        } else if (PROPERTY_MARKROLLBACKONLY.equals(id)) {
            this.setMarkRollbackOnly(Objects.convertTo(value, Boolean.class));
        } else if (PROPERTY_MARKROLLBACKONLYLAST.equals(id)) {
            this.setMarkRollbackOnlyLast(Objects.convertTo(value, Boolean.class));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_MESSAGE.equals(id)) {
            return this.getMessage();
        }
        if (PROPERTY_MARKROLLBACKONLY.equals(id)) {
            return this.getMarkRollbackOnly();
        }
        if (PROPERTY_MARKROLLBACKONLYLAST.equals(id)) {
            return this.getMarkRollbackOnlyLast();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        RollbackDefinition answer = new RollbackDefinition();
        answer.setMessage(this.toXmlPropertyValue(PROPERTY_MESSAGE, this.getMessage()));
        answer.setMarkRollbackOnly(this.toXmlPropertyValue(PROPERTY_MARKROLLBACKONLY, this.getMarkRollbackOnly()));
        answer.setMarkRollbackOnlyLast(this.toXmlPropertyValue(PROPERTY_MARKROLLBACKONLYLAST, this.getMarkRollbackOnlyLast()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return RollbackDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof RollbackDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof RollbackDefinition. Was " + processor.getClass().getName());
        }
        RollbackDefinition node = (RollbackDefinition)processor;
        this.setMessage(node.getMessage());
        this.setMarkRollbackOnly(node.getMarkRollbackOnly());
        this.setMarkRollbackOnlyLast(node.getMarkRollbackOnlyLast());
    }
}

