/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model.generated;

import com.fusesource.rider.commons.properties.BooleanPropertyDescriptor;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.ExpressionPropertyDescriptor;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.generated.Messages;
import com.fusesource.rider.model.util.Objects;
import java.util.Map;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class RoutingSlip
extends AbstractNode {
    public static final String PROPERTY_EXPRESSION = "RoutingSlip.Expression";
    public static final String PROPERTY_URIDELIMITER = "RoutingSlip.UriDelimiter";
    public static final String PROPERTY_IGNOREINVALIDENDPOINTS = "RoutingSlip.IgnoreInvalidEndpoints";
    private ExpressionDefinition expression;
    private String uriDelimiter;
    private Boolean ignoreInvalidEndpoints;

    public RoutingSlip() {
    }

    public RoutingSlip(RoutingSlipDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "routingSlip.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "routingSlipEIP";
    }

    @Override
    public String getCategoryName() {
        return "Routing";
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        ExpressionDefinition oldValue = this.expression;
        this.expression = expression;
        this.firePropertyChange(PROPERTY_EXPRESSION, oldValue, expression);
    }

    public String getUriDelimiter() {
        return this.uriDelimiter;
    }

    public void setUriDelimiter(String uriDelimiter) {
        String oldValue = this.uriDelimiter;
        this.uriDelimiter = uriDelimiter;
        this.firePropertyChange(PROPERTY_URIDELIMITER, oldValue, uriDelimiter);
    }

    public Boolean getIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(Boolean ignoreInvalidEndpoints) {
        Boolean oldValue = this.ignoreInvalidEndpoints;
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
        this.firePropertyChange(PROPERTY_IGNOREINVALIDENDPOINTS, oldValue, ignoreInvalidEndpoints);
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        ExpressionPropertyDescriptor descExpression = new ExpressionPropertyDescriptor(PROPERTY_EXPRESSION, Messages.propertyLabelRoutingSlipExpression);
        TextPropertyDescriptor descUriDelimiter = new TextPropertyDescriptor((Object)PROPERTY_URIDELIMITER, Messages.propertyLabelRoutingSlipUriDelimiter);
        BooleanPropertyDescriptor descIgnoreInvalidEndpoints = new BooleanPropertyDescriptor((Object)PROPERTY_IGNOREINVALIDENDPOINTS, Messages.propertyLabelRoutingSlipIgnoreInvalidEndpoints);
        descriptors.put(PROPERTY_EXPRESSION, descExpression);
        descriptors.put(PROPERTY_URIDELIMITER, (PropertyDescriptor)descUriDelimiter);
        descriptors.put(PROPERTY_IGNOREINVALIDENDPOINTS, (PropertyDescriptor)descIgnoreInvalidEndpoints);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_EXPRESSION.equals(id)) {
            this.setExpression(Objects.convertTo(value, ExpressionDefinition.class));
        } else if (PROPERTY_URIDELIMITER.equals(id)) {
            this.setUriDelimiter(Objects.convertTo(value, String.class));
        } else if (PROPERTY_IGNOREINVALIDENDPOINTS.equals(id)) {
            this.setIgnoreInvalidEndpoints(Objects.convertTo(value, Boolean.class));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_EXPRESSION.equals(id)) {
            return this.getExpression();
        }
        if (PROPERTY_URIDELIMITER.equals(id)) {
            return this.getUriDelimiter();
        }
        if (PROPERTY_IGNOREINVALIDENDPOINTS.equals(id)) {
            return this.getIgnoreInvalidEndpoints();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        RoutingSlipDefinition answer = new RoutingSlipDefinition();
        answer.setExpression(this.toXmlPropertyValue(PROPERTY_EXPRESSION, this.getExpression()));
        answer.setUriDelimiter(this.toXmlPropertyValue(PROPERTY_URIDELIMITER, this.getUriDelimiter()));
        answer.setIgnoreInvalidEndpoints(this.toXmlPropertyValue(PROPERTY_IGNOREINVALIDENDPOINTS, this.getIgnoreInvalidEndpoints()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return RoutingSlipDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof RoutingSlipDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof RoutingSlipDefinition. Was " + processor.getClass().getName());
        }
        RoutingSlipDefinition node = (RoutingSlipDefinition)processor;
        this.setExpression(node.getExpression());
        this.setUriDelimiter(node.getUriDelimiter());
        this.setIgnoreInvalidEndpoints(node.getIgnoreInvalidEndpoints());
    }
}

