/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model.generated;

import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.ExpressionPropertyDescriptor;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.generated.Messages;
import com.fusesource.rider.model.util.Objects;
import java.util.Map;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class SetHeader
extends AbstractNode {
    public static final String PROPERTY_EXPRESSION = "SetHeader.Expression";
    public static final String PROPERTY_HEADERNAME = "SetHeader.HeaderName";
    private ExpressionDefinition expression;
    private String headerName;

    public SetHeader() {
    }

    public SetHeader(SetHeaderDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "transform.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "setHeaderNode";
    }

    @Override
    public String getCategoryName() {
        return "Transformation";
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        ExpressionDefinition oldValue = this.expression;
        this.expression = expression;
        this.firePropertyChange(PROPERTY_EXPRESSION, oldValue, expression);
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        String oldValue = this.headerName;
        this.headerName = headerName;
        this.firePropertyChange(PROPERTY_HEADERNAME, oldValue, headerName);
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        ExpressionPropertyDescriptor descExpression = new ExpressionPropertyDescriptor(PROPERTY_EXPRESSION, Messages.propertyLabelSetHeaderExpression);
        TextPropertyDescriptor descHeaderName = new TextPropertyDescriptor((Object)PROPERTY_HEADERNAME, Messages.propertyLabelSetHeaderHeaderName);
        descriptors.put(PROPERTY_EXPRESSION, descExpression);
        descriptors.put(PROPERTY_HEADERNAME, (PropertyDescriptor)descHeaderName);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_EXPRESSION.equals(id)) {
            this.setExpression(Objects.convertTo(value, ExpressionDefinition.class));
        } else if (PROPERTY_HEADERNAME.equals(id)) {
            this.setHeaderName(Objects.convertTo(value, String.class));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_EXPRESSION.equals(id)) {
            return this.getExpression();
        }
        if (PROPERTY_HEADERNAME.equals(id)) {
            return this.getHeaderName();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        SetHeaderDefinition answer = new SetHeaderDefinition();
        answer.setExpression(this.toXmlPropertyValue(PROPERTY_EXPRESSION, this.getExpression()));
        answer.setHeaderName(this.toXmlPropertyValue(PROPERTY_HEADERNAME, this.getHeaderName()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return SetHeaderDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof SetHeaderDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof SetHeaderDefinition. Was " + processor.getClass().getName());
        }
        SetHeaderDefinition node = (SetHeaderDefinition)processor;
        this.setExpression(node.getExpression());
        this.setHeaderName(node.getHeaderName());
    }
}

