/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model.generated;

import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.ExpressionPropertyDescriptor;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.generated.Messages;
import com.fusesource.rider.model.util.Objects;
import java.util.Map;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SetPropertyDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class SetProperty
extends AbstractNode {
    public static final String PROPERTY_EXPRESSION = "SetProperty.Expression";
    public static final String PROPERTY_PROPERTYNAME = "SetProperty.PropertyName";
    private ExpressionDefinition expression;
    private String propertyName;

    public SetProperty() {
    }

    public SetProperty(SetPropertyDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "transform.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "setPropertyNode";
    }

    @Override
    public String getCategoryName() {
        return "Transformation";
    }

    public ExpressionDefinition getExpression() {
        return this.expression;
    }

    public void setExpression(ExpressionDefinition expression) {
        ExpressionDefinition oldValue = this.expression;
        this.expression = expression;
        this.firePropertyChange(PROPERTY_EXPRESSION, oldValue, expression);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        String oldValue = this.propertyName;
        this.propertyName = propertyName;
        this.firePropertyChange(PROPERTY_PROPERTYNAME, oldValue, propertyName);
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        ExpressionPropertyDescriptor descExpression = new ExpressionPropertyDescriptor(PROPERTY_EXPRESSION, Messages.propertyLabelSetPropertyExpression);
        TextPropertyDescriptor descPropertyName = new TextPropertyDescriptor((Object)PROPERTY_PROPERTYNAME, Messages.propertyLabelSetPropertyPropertyName);
        descriptors.put(PROPERTY_EXPRESSION, descExpression);
        descriptors.put(PROPERTY_PROPERTYNAME, (PropertyDescriptor)descPropertyName);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_EXPRESSION.equals(id)) {
            this.setExpression(Objects.convertTo(value, ExpressionDefinition.class));
        } else if (PROPERTY_PROPERTYNAME.equals(id)) {
            this.setPropertyName(Objects.convertTo(value, String.class));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_EXPRESSION.equals(id)) {
            return this.getExpression();
        }
        if (PROPERTY_PROPERTYNAME.equals(id)) {
            return this.getPropertyName();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        SetPropertyDefinition answer = new SetPropertyDefinition();
        answer.setExpression(this.toXmlPropertyValue(PROPERTY_EXPRESSION, this.getExpression()));
        answer.setPropertyName(this.toXmlPropertyValue(PROPERTY_PROPERTYNAME, this.getPropertyName()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return SetPropertyDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof SetPropertyDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof SetPropertyDefinition. Was " + processor.getClass().getName());
        }
        SetPropertyDefinition node = (SetPropertyDefinition)processor;
        this.setExpression(node.getExpression());
        this.setPropertyName(node.getPropertyName());
    }
}

