/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model.io;

import com.fusesource.rider.model.Activator;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.io.ContainerMarshallerSupport;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.camel.model.RouteDefinition;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fusesource.camel.rider.util.RouteXml;
import org.fusesource.camel.rider.util.XmlModel;
import org.fusesource.scalate.util.IOUtil;

public class XmlContainerMarshaller
extends ContainerMarshallerSupport {
    @Override
    public RouteContainer loadRoutes(File file) {
        try {
            RouteXml helper = this.createXmlHelper();
            Activator.getLogger().debug("Loading file: " + file);
            XmlModel model = helper.unmarshal(file);
            return this.toContainer(model);
        }
        catch (Exception e) {
            Activator.getLogger().error("Failed to load Camel mode: " + e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public RouteContainer loadRoutesFromText(String text) {
        try {
            RouteXml helper = this.createXmlHelper();
            XmlModel model = helper.unmarshal(text);
            return this.toContainer(model);
        }
        catch (Exception e) {
            Activator.getLogger().error("Failed to load Camel mode: " + e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected RouteContainer toContainer(XmlModel model) {
        List routes = model.getRouteDefinitionList();
        RouteContainer answer = new RouteContainer();
        answer.addRoutes(routes);
        answer.setBeans(model.beanMap());
        answer.setCamelContextEndpointUris(model.endpointUriSet());
        answer.setModel(model);
        return answer;
    }

    @Override
    public void save(IFile ifile, RouteContainer model, IProgressMonitor monitor) throws CoreException {
        RouteXml helper = this.createXmlHelper();
        List<RouteDefinition> list = model.createRouteDefinitions();
        String text = IOUtil.loadText((InputStream)ifile.getContents(), (String)ifile.getCharset());
        String newText = helper.marshalToText(text, list);
        ifile.setContents((InputStream)new ByteArrayInputStream(newText.getBytes()), true, true, monitor);
    }

    @Override
    public void save(File file, RouteContainer model) {
        List<RouteDefinition> list = model.createRouteDefinitions();
        RouteXml helper = this.createXmlHelper();
        Activator.getLogger().debug("Saving to file " + file + " routes: " + list);
        helper.marshal(file, list);
    }

    protected RouteXml createXmlHelper() {
        return new RouteXml();
    }

    @Override
    public String updateText(String xmlText, RouteContainer model) {
        List<RouteDefinition> list = model.createRouteDefinitions();
        RouteXml helper = this.createXmlHelper();
        return helper.marshalToText(xmlText, list);
    }
}

