/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model.util;

import com.fusesource.rider.commons.util.Strings;
import com.fusesource.rider.model.Activator;
import com.fusesource.rider.model.HasValue;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.converter.ObjectConverter;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.util.ObjectHelper;

public class Objects
extends com.fusesource.rider.commons.util.Objects {
    public static boolean equal(Object a, Object b) {
        if (a == b) {
            return true;
        }
        return a != null && b != null && a.equals(b);
    }

    public static <T> T convertTo(Object value, Class<T> aClass) {
        if (ExpressionSubElementDefinition.class.isAssignableFrom(aClass) && value instanceof ExpressionDefinition) {
            ExpressionDefinition exp = (ExpressionDefinition)value;
            ExpressionSubElementDefinition answer = new ExpressionSubElementDefinition();
            answer.setExpressionType(exp);
            return (T)answer;
        }
        if (ExpressionDefinition.class.isAssignableFrom(aClass) && value instanceof ExpressionSubElementDefinition) {
            ExpressionSubElementDefinition exp = (ExpressionSubElementDefinition)value;
            return (T)exp.getExpressionType();
        }
        if (ExpressionDefinition.class.isAssignableFrom(aClass) && value instanceof List) {
            Object object;
            List list = (List)value;
            if (list.size() > 0 && (object = list.get(0)) instanceof ExpressionDefinition) {
                return (T)object;
            }
            return null;
        }
        if (List.class.isAssignableFrom(aClass) && value instanceof ExpressionDefinition) {
            ArrayList<ExpressionDefinition> answer = new ArrayList<ExpressionDefinition>();
            answer.add((ExpressionDefinition)value);
            return (T)answer;
        }
        if (Boolean.TYPE.isAssignableFrom(aClass)) {
            Boolean b = ObjectConverter.toBool((Object)value);
            return (T)b;
        }
        if (Boolean.class.isAssignableFrom(aClass)) {
            Boolean b = ObjectConverter.toBoolean((Object)value);
            if (b == null || !b.booleanValue()) {
                return null;
            }
            return (T)b;
        }
        if (Byte.class.isAssignableFrom(aClass)) {
            return (T)ObjectConverter.toByte((Object)value);
        }
        if (Short.class.isAssignableFrom(aClass)) {
            return (T)ObjectConverter.toShort((Object)value);
        }
        if (Integer.class.isAssignableFrom(aClass)) {
            return (T)ObjectConverter.toInteger((Object)value);
        }
        if (Long.class.isAssignableFrom(aClass)) {
            return (T)ObjectConverter.toLong((Object)value);
        }
        if (Float.class.isAssignableFrom(aClass)) {
            return (T)ObjectConverter.toFloat((Object)value);
        }
        if (Double.class.isAssignableFrom(aClass)) {
            return (T)ObjectConverter.toDouble((Object)value);
        }
        if (String.class.isAssignableFrom(aClass)) {
            String s;
            if (value != null && (s = value.toString()).length() > 0) {
                return (T)s;
            }
            return null;
        }
        if (value == null || aClass.isInstance(value)) {
            return aClass.cast(value);
        }
        throw new ClassCastException("Cannot convert " + value.getClass().getName() + " to " + aClass.getName());
    }

    public static <T> T getField(Object instance, String fieldName) {
        Exception reason = null;
        try {
            Field field = Objects.getFieldDescriptor(instance, fieldName);
            return (T)field.get(instance);
        }
        catch (NoSuchFieldException e) {
            String c = Strings.capitalize((String)fieldName);
            Class<?> clazz = instance.getClass();
            Method method = null;
            try {
                method = clazz.getMethod("get" + c, new Class[0]);
            }
            catch (Exception exception) {}
            if (method == null) {
                try {
                    method = clazz.getMethod("is" + c, new Class[0]);
                }
                catch (Exception exception) {}
            }
            if (method != null) {
                try {
                    return (T)method.invoke(instance, new Object[0]);
                }
                catch (Exception e1) {
                    reason = e1;
                }
            } else {
                reason = e;
            }
        }
        catch (Exception e) {
            reason = e;
        }
        Activator.getLogger().debug("Could not get field: " + fieldName + " on " + instance + ". Reason: " + reason, (Throwable)reason);
        return null;
    }

    public static void setField(Object instance, String fieldName, Object value) {
        HasValue has;
        if (value instanceof HasValue && !(has = (HasValue)value).hasValue()) {
            return;
        }
        try {
            Field field = Objects.getFieldDescriptor(instance, fieldName);
            Object convertedValue = Objects.convertTo(value, field.getType());
            field.set(instance, convertedValue);
        }
        catch (Exception e) {
            Activator.getLogger().debug("Could not set field: " + fieldName + " on " + instance + " to value: " + value + ". Reason: " + e, (Throwable)e);
        }
    }

    public static Field getFieldDescriptor(Object instance, String fieldName) throws NoSuchFieldException {
        ObjectHelper.notNull((Object)instance, (String)"instance");
        Field field = instance.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }
}

