/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc.ui.util.bidi.profile;

import org.eclipse.birt.report.data.bidi.utils.core.BidiFormat;
import org.eclipse.birt.report.data.bidi.utils.i18n.Messages;
import org.eclipse.birt.report.data.bidi.utils.ui.BidiGUIUtility;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.Utility;
import org.eclipse.birt.report.data.oda.jdbc.ui.util.bidi.profile.BidiSettingsSupport;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AdvancedBidiDialog
extends TitleAreaDialog {
    public static final String ADVANCED_DIALOG_TITLE = Messages.getString((String)"advancedbididialog.title");
    public static final String ADVANCED_DIALOG_MSG = Messages.getString((String)"advancedbididialog.msg");
    private static final String DISABLE_BIDI_CHECKBOX_TEXT = Messages.getString((String)"disablebidi.checkbox.label");
    private Group bidiMetadataFormatFrame;
    private Group bidiContentFormatFrame;
    private Object parentDialog;
    private Button disableTransformButton = null;
    private boolean disableTransform = false;
    private BidiFormat metadataBidiFormat = null;
    private BidiFormat contentBidiFormat = null;
    private BidiFormat disabledMetadataBidiFormat = null;
    private BidiFormat disabledContentBidiFormat = null;

    public AdvancedBidiDialog(Object parentDialog) {
        this(PlatformUI.getWorkbench().getDisplay().getActiveShell(), parentDialog);
    }

    public AdvancedBidiDialog(Shell parentShell, Object parentDialog) {
        super(parentShell);
        this.parentDialog = parentDialog;
        if (parentDialog instanceof BidiSettingsSupport) {
            this.contentBidiFormat = ((BidiSettingsSupport)parentDialog).getContentBidiFormat();
            this.metadataBidiFormat = ((BidiSettingsSupport)parentDialog).getMetadataBidiFormat();
            this.disabledContentBidiFormat = ((BidiSettingsSupport)parentDialog).getDdisabledContentBidiFormat();
            this.disabledMetadataBidiFormat = ((BidiSettingsSupport)parentDialog).getDdisabledMetadataBidiFormat();
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        contents.setLayoutData((Object)new GridData(1808));
        contents.setLayout((Layout)new GridLayout());
        this.setTitle(ADVANCED_DIALOG_TITLE);
        this.setMessage(ADVANCED_DIALOG_MSG);
        this.getShell().setText(ADVANCED_DIALOG_TITLE);
        AdvancedBidiDialog.applyDialogFont((Control)contents);
        this.initializeDialogUnits((Control)area);
        if (this.disabledContentBidiFormat != null && this.disabledMetadataBidiFormat != null && !"".equals(this.disabledContentBidiFormat) && !"".equals(this.disabledMetadataBidiFormat)) {
            this.disableTransform = true;
        }
        Composite bidiArea = new Composite(area, 0);
        GridLayout bidiGridLayout = new GridLayout();
        bidiGridLayout.numColumns = 4;
        bidiGridLayout.marginHeight = 10;
        bidiGridLayout.marginWidth = 5;
        bidiGridLayout.horizontalSpacing = 5;
        bidiGridLayout.verticalSpacing = 10;
        bidiGridLayout.makeColumnsEqualWidth = true;
        bidiArea.setLayout((Layout)bidiGridLayout);
        this.bidiMetadataFormatFrame = BidiGUIUtility.INSTANCE.addBiDiFormatFrame(bidiArea, "External_system_metadata_setting_area", this.disableTransform ? this.disabledMetadataBidiFormat : this.metadataBidiFormat);
        this.bidiContentFormatFrame = BidiGUIUtility.INSTANCE.addBiDiFormatFrame(bidiArea, "External_system_content_setting_area", this.disableTransform ? this.disabledContentBidiFormat : this.contentBidiFormat);
        this.disableTransformButton = new Button(bidiArea, 32);
        this.disableTransformButton.setText(DISABLE_BIDI_CHECKBOX_TEXT);
        this.disableTransformButton.setSelection(this.disableTransform);
        if (this.disableTransform) {
            this.handleDisableTransform();
        }
        this.disableTransformButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedBidiDialog.this.disableTransform = !AdvancedBidiDialog.this.disableTransform;
                AdvancedBidiDialog.this.handleDisableTransform();
            }
        });
        Utility.setSystemHelp((Control)area, "org.eclipse.birt.cshelp.Dialog_JDBC_BIDISetting_ID");
        return area;
    }

    protected void okPressed() {
        if (!this.disableTransform) {
            this.metadataBidiFormat = BidiGUIUtility.INSTANCE.getBiDiFormat(this.bidiMetadataFormatFrame);
            this.contentBidiFormat = BidiGUIUtility.INSTANCE.getBiDiFormat(this.bidiContentFormatFrame);
            this.disabledMetadataBidiFormat = null;
            this.disabledContentBidiFormat = null;
        } else {
            this.disabledMetadataBidiFormat = BidiGUIUtility.INSTANCE.getBiDiFormat(this.bidiMetadataFormatFrame);
            this.disabledContentBidiFormat = BidiGUIUtility.INSTANCE.getBiDiFormat(this.bidiContentFormatFrame);
            this.metadataBidiFormat = new BidiFormat("ILYNN");
            this.contentBidiFormat = new BidiFormat("ILYNN");
        }
        if (this.parentDialog instanceof BidiSettingsSupport) {
            ((BidiSettingsSupport)this.parentDialog).setBidiFormats(this.metadataBidiFormat, this.contentBidiFormat, this.disabledMetadataBidiFormat, this.disabledContentBidiFormat);
        }
        super.okPressed();
    }

    public boolean close() {
        return super.close();
    }

    public int open() {
        try {
            if (this.getShell() == null) {
                this.create();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.open();
    }

    private void handleDisableTransform() {
        int j;
        Control[] children = this.bidiContentFormatFrame.getChildren();
        Control[] childrenArabicSpecific = null;
        Group arabicGroup = null;
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(!this.disableTransform);
            if (children[i] instanceof Group) {
                arabicGroup = (Group)children[i];
                childrenArabicSpecific = arabicGroup.getChildren();
                j = 0;
                while (j < childrenArabicSpecific.length) {
                    childrenArabicSpecific[j].setEnabled(!this.disableTransform);
                    ++j;
                }
            }
            ++i;
        }
        children = this.bidiMetadataFormatFrame.getChildren();
        i = 0;
        while (i < children.length) {
            children[i].setEnabled(!this.disableTransform);
            if (children[i] instanceof Group) {
                arabicGroup = (Group)children[i];
                childrenArabicSpecific = arabicGroup.getChildren();
                j = 0;
                while (j < childrenArabicSpecific.length) {
                    childrenArabicSpecific[j].setEnabled(!this.disableTransform);
                    ++j;
                }
            }
            ++i;
        }
    }
}

