/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.BuilderSupport;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RouteBuilder
extends BuilderSupport
implements RoutesBuilder {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private RoutesDefinition routeCollection = new RoutesDefinition();

    public RouteBuilder() {
        this(null);
    }

    public RouteBuilder(CamelContext context) {
        super(context);
    }

    public String toString() {
        return this.getRouteCollection().toString();
    }

    public abstract void configure() throws Exception;

    public RouteDefinition from(String uri) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(uri);
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition fromF(String uri, Object ... args) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(String.format(uri, args));
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition from(Endpoint endpoint) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(endpoint);
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition from(String ... uris) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(uris);
        this.configureRoute(answer);
        return answer;
    }

    public RouteDefinition from(Endpoint ... endpoints) {
        this.getRouteCollection().setCamelContext(this.getContext());
        RouteDefinition answer = this.getRouteCollection().from(endpoints);
        this.configureRoute(answer);
        return answer;
    }

    public void errorHandler(ErrorHandlerBuilder errorHandlerBuilder) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("errorHandler must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        this.setErrorHandlerBuilder(errorHandlerBuilder);
    }

    public InterceptDefinition intercept() {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("intercept must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().intercept();
    }

    public InterceptFromDefinition interceptFrom() {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("interceptFrom must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().interceptFrom();
    }

    public InterceptFromDefinition interceptFrom(String uri) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("interceptFrom must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().interceptFrom(uri);
    }

    public InterceptSendToEndpointDefinition interceptSendToEndpoint(String uri) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("interceptSendToEndpoint must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().interceptSendToEndpoint(uri);
    }

    public OnExceptionDefinition onException(Class exception) {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("onException must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().onException(exception);
    }

    public OnExceptionDefinition onException(Class ... exceptions) {
        OnExceptionDefinition last = null;
        for (Class ex : exceptions) {
            last = last == null ? this.onException(ex) : last.onException(ex);
        }
        return last != null ? last : this.onException((Class)Exception.class);
    }

    public OnCompletionDefinition onCompletion() {
        if (!this.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("onCompletion must be defined before any routes in the RouteBuilder");
        }
        this.getRouteCollection().setCamelContext(this.getContext());
        return this.getRouteCollection().onCompletion();
    }

    @Override
    public ModelCamelContext getContext() {
        ModelCamelContext context = super.getContext();
        if (context == null) {
            context = this.createContainer();
            this.setContext(context);
        }
        return context;
    }

    @Override
    public void addRoutesToCamelContext(CamelContext context) throws Exception {
        this.configureRoutes((ModelCamelContext)context);
        this.populateRoutes();
    }

    public RoutesDefinition configureRoutes(ModelCamelContext context) throws Exception {
        this.setContext(context);
        this.checkInitialized();
        this.routeCollection.setCamelContext(context);
        return this.routeCollection;
    }

    public void includeRoutes(RoutesBuilder routes) throws Exception {
        if (routes instanceof RouteBuilder) {
            RouteBuilder builder = (RouteBuilder)routes;
            builder.setContext(this.getContext());
            builder.setRouteCollection(this.getRouteCollection());
            builder.setErrorHandlerBuilder(this.getErrorHandlerBuilder());
            builder.configure();
        } else {
            this.getContext().addRoutes(routes);
        }
    }

    @Override
    public void setErrorHandlerBuilder(ErrorHandlerBuilder errorHandlerBuilder) {
        super.setErrorHandlerBuilder(errorHandlerBuilder);
        this.getRouteCollection().setErrorHandlerBuilder(this.getErrorHandlerBuilder());
    }

    protected void checkInitialized() throws Exception {
        if (this.initialized.compareAndSet(false, true)) {
            ModelCamelContext camelContext = this.getContext();
            if (camelContext.getErrorHandlerBuilder() != null) {
                this.setErrorHandlerBuilder(camelContext.getErrorHandlerBuilder());
            }
            this.configure();
            for (RouteDefinition route : this.getRouteCollection().getRoutes()) {
                route.markPrepared();
            }
        }
    }

    protected void populateRoutes() throws Exception {
        ModelCamelContext camelContext = this.getContext();
        if (camelContext == null) {
            throw new IllegalArgumentException("CamelContext has not been injected!");
        }
        this.getRouteCollection().setCamelContext(camelContext);
        camelContext.addRouteDefinitions(this.getRouteCollection().getRoutes());
    }

    public void setRouteCollection(RoutesDefinition routeCollection) {
        this.routeCollection = routeCollection;
    }

    public RoutesDefinition getRouteCollection() {
        return this.routeCollection;
    }

    protected ModelCamelContext createContainer() {
        return new DefaultCamelContext();
    }

    protected void configureRoute(RouteDefinition route) {
        route.setGroup(this.getClass().getName());
    }

    @Deprecated
    protected void addRoutes(RoutesBuilder routes) throws Exception {
        this.includeRoutes(routes);
    }
}

