/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.PollingConsumer;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.EventDrivenPollingConsumer;
import org.apache.camel.impl.MappedEndpointConfiguration;
import org.apache.camel.spi.HasId;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public abstract class DefaultEndpoint
extends ServiceSupport
implements Endpoint,
HasId,
CamelContextAware {
    private String endpointUri;
    private EndpointConfiguration endpointConfiguration;
    private CamelContext camelContext;
    private Component component;
    private ExchangePattern exchangePattern = ExchangePattern.InOnly;
    private boolean synchronous;
    private final String id = EndpointHelper.createEndpointId();

    protected DefaultEndpoint(String endpointUri, Component component) {
        this.camelContext = component == null ? null : component.getCamelContext();
        this.component = component;
        this.setEndpointUri(endpointUri);
    }

    @Deprecated
    protected DefaultEndpoint(String endpointUri, CamelContext camelContext) {
        this(endpointUri);
        this.camelContext = camelContext;
    }

    @Deprecated
    protected DefaultEndpoint(String endpointUri) {
        this.setEndpointUri(endpointUri);
    }

    protected DefaultEndpoint() {
    }

    public int hashCode() {
        return this.getEndpointUri().hashCode() * 37 + 1;
    }

    public boolean equals(Object object) {
        if (object instanceof DefaultEndpoint) {
            DefaultEndpoint that = (DefaultEndpoint)object;
            return ObjectHelper.equal(this.getEndpointUri(), that.getEndpointUri());
        }
        return false;
    }

    public String toString() {
        return String.format("Endpoint[%s]", URISupport.sanitizeUri(this.getEndpointUri()));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getEndpointUri() {
        if (this.endpointUri == null) {
            this.endpointUri = this.createEndpointUri();
            if (this.endpointUri == null) {
                throw new IllegalArgumentException("endpointUri is not specified and " + this.getClass().getName() + " does not implement createEndpointUri() to create a default value");
            }
        }
        return this.endpointUri;
    }

    @Override
    public EndpointConfiguration getEndpointConfiguration() {
        if (this.endpointConfiguration == null) {
            this.endpointConfiguration = this.createEndpointConfiguration(this.getEndpointUri());
        }
        return this.endpointConfiguration;
    }

    public void setEndpointConfiguration(EndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }

    @Override
    public String getEndpointKey() {
        if (this.isLenientProperties()) {
            String uri = this.getEndpointUri();
            if (uri.indexOf(63) != -1) {
                return ObjectHelper.before(uri, "?");
            }
            return uri;
        }
        return this.getEndpointUri();
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Component getComponent() {
        return this.component;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public PollingConsumer createPollingConsumer() throws Exception {
        return new EventDrivenPollingConsumer(this);
    }

    @Override
    public Exchange createExchange(Exchange exchange) {
        return exchange.copy();
    }

    @Override
    public Exchange createExchange() {
        return this.createExchange(this.getExchangePattern());
    }

    @Override
    public Exchange createExchange(ExchangePattern pattern) {
        return new DefaultExchange(this, pattern);
    }

    public ExchangePattern getExchangePattern() {
        return this.exchangePattern;
    }

    public void setExchangePattern(ExchangePattern exchangePattern) {
        this.exchangePattern = exchangePattern;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    @Override
    public void configureProperties(Map<String, Object> options) {
    }

    protected String createEndpointUri() {
        return null;
    }

    protected EndpointConfiguration createEndpointConfiguration(String uri) {
        if (this.getComponent() != null) {
            try {
                return this.getComponent().createConfiguration(uri);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        if (this.getCamelContext() != null) {
            return new MappedEndpointConfiguration(this.getCamelContext(), uri);
        }
        return null;
    }

    public void setEndpointUriIfNotSpecified(String value) {
        if (this.endpointUri == null) {
            this.setEndpointUri(value);
        }
    }

    protected void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

