/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal.localjmx;

import com.fusesource.ide.jmx.core.ExtensionManager;
import com.fusesource.ide.jmx.core.IConnectionProvider;
import com.fusesource.ide.jmx.core.IConnectionWrapper;
import com.fusesource.ide.jmx.core.IJMXRunnable;
import com.fusesource.ide.jmx.core.JMXCoreMessages;
import com.fusesource.ide.jmx.core.JMXException;
import com.fusesource.ide.jmx.core.providers.DefaultConnectionProvider;
import com.fusesource.ide.jmx.core.tree.NodeUtils;
import com.fusesource.ide.jmx.core.tree.Root;
import com.fusesource.ide.jmx.ui.JMXUIActivator;
import com.fusesource.ide.jmx.ui.internal.localjmx.Activator;
import com.fusesource.ide.jmx.ui.internal.localjmx.JvmConnectionsNode;
import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.internal.ui.IJvmFacade;
import com.fusesource.ide.jvmmonitor.ui.JvmMonitorPreferences;
import com.fusesource.rider.commons.tree.HasName;
import com.fusesource.rider.commons.tree.HasRefreshableUI;
import com.fusesource.rider.commons.tree.RefreshableUI;
import com.fusesource.rider.commons.ui.ImageProvider;
import com.fusesource.rider.commons.ui.drop.DelegateDropListener;
import com.fusesource.rider.commons.ui.drop.DropHandler;
import com.fusesource.rider.commons.ui.drop.DropHandlerFactory;
import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.commons.util.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class JvmConnectionWrapper
implements IConnectionWrapper,
HasName,
ImageProvider,
HasRefreshableUI,
IAdaptable,
IJvmFacade,
DropHandlerFactory {
    private static final String MAVEN_PREFIX = "org.codehaus.plexus.classworlds.launcher.Launcher";
    private static final String ECLIPSE_MAVEN_PROCESS_PREFIX = "-DECLIPSE_PROCESS_NAME='";
    private static final String ECLIPSE_MAVEN_PROCESS_POSTFIX = "'";
    private static final String KARAF_HOME_PREFIX = " -Dkaraf.home=";
    private static final String KARAF_HOME_POSTFIX = " ";
    protected static final Map<String, String> vmAliasMap = new HashMap<String, String>();
    protected static final Map<String, String> karafSubTypeMap = new HashMap<String, String>();
    protected static final Map<Integer, String> processInformationStore = new HashMap<Integer, String>();
    private final JvmConnectionsNode parent;
    private IActiveJvm activeJvm;
    private String name;
    private Root root;
    private Image image;
    private List<Runnable> afterLoadRunnables = new ArrayList<Runnable>();

    static {
        vmAliasMap.put("com.intellij.rt.execution.application.AppMain", "idea");
        vmAliasMap.put("org.apache.karaf.main.Main", "karaf");
        vmAliasMap.put("org.eclipse.equinox.launcher.Main", "equinox");
        vmAliasMap.put("org.jetbrains.idea.maven.server.RemoteMavenServer", "idea maven server");
        vmAliasMap.put("idea maven server", "");
        vmAliasMap.put("scala.tools.nsc.MainGenericRunner", "scala repl");
        karafSubTypeMap.put("default", "Apache Karaf");
        karafSubTypeMap.put("esb-version.jar", "Fuse ESB");
        karafSubTypeMap.put("fabric-version.jar", "Fuse Fabric");
        karafSubTypeMap.put("mq-version.jar", "Fuse MQ");
        karafSubTypeMap.put("servicemix-version.jar", "Apache ServiceMix");
    }

    public JvmConnectionWrapper(JvmConnectionsNode parent, JMXServiceURL url, IActiveJvm vm) {
        this.parent = parent;
        this.activeJvm = vm;
    }

    public String toString() {
        return this.getName();
    }

    public IActiveJvm getActiveJvm() {
        return this.activeJvm;
    }

    public void setActiveJvm(IActiveJvm activeJvm) {
        if (this.activeJvm != activeJvm) {
            IActiveJvm oldJvm = this.activeJvm;
            this.activeJvm = activeJvm;
            if (oldJvm != null) {
                try {
                    oldJvm.disconnect();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            ITabbedPropertySheetPageContributor contributor = new ITabbedPropertySheetPageContributor(){

                public String getContributorId() {
                    return "com.fusesource.ide.jvmmonitor.ui.JvmExplorer";
                }
            };
            TabbedPropertySheetPage page = new TabbedPropertySheetPage(contributor);
            return page;
        }
        return null;
    }

    public DropHandler createDropHandler(DropTargetEvent event) {
        DropHandler handler;
        if (this.isConnected() && (handler = DelegateDropListener.createDropHandler((Object)this.getRoot(), (DropTargetEvent)event)) != null) {
            return handler;
        }
        String lowerName = this.getName().toLowerCase();
        if (lowerName.contains("karaf") || lowerName.contains("fuse") || lowerName.contains("fmc")) {
            return new DropHandler(){

                public void drop(final DropTargetEvent event) {
                    JvmConnectionWrapper.this.addOnLoadRunnable(new Runnable(){

                        @Override
                        public void run() {
                            System.out.println("Dropping on newly connected ESB!");
                            Root r = JvmConnectionWrapper.this.getRoot();
                            if (r == null) {
                                System.out.println("Cannot drop as no root yet, we've probably not been able to connect to " + JvmConnectionWrapper.this.getName());
                            } else {
                                DropHandler handler = DelegateDropListener.createDropHandler((Object)r, (DropTargetEvent)event);
                                if (handler != null) {
                                    handler.drop(event);
                                } else {
                                    System.out.println("No DropHandler available. We've probably not been able to connect to " + JvmConnectionWrapper.this.getName());
                                }
                            }
                        }
                    });
                    if (!JvmConnectionWrapper.this.isConnected()) {
                        try {
                            JvmConnectionWrapper.this.connect();
                            JvmConnectionWrapper.this.loadRoot();
                        }
                        catch (Exception e) {
                            Activator.getLogger().warning("Could not connect to " + this + ". " + e, (Throwable)e);
                        }
                    }
                }
            };
        }
        return null;
    }

    protected void addOnLoadRunnable(Runnable runnable) {
        this.afterLoadRunnables.add(runnable);
    }

    public JMXConnector getConnector() {
        return this.activeJvm.getMBeanServer().getConnector();
    }

    public MBeanServerConnection getConnection() {
        return this.activeJvm.getMBeanServer().getConnection();
    }

    public synchronized void connect() throws Exception {
        if (!this.activeJvm.isConnected() && this.activeJvm.isConnectionSupported()) {
            int updatePeriod = JvmMonitorPreferences.getJvmUpdatePeriod();
            this.activeJvm.connect(updatePeriod);
            this.fireConnectionChanged();
        }
    }

    public synchronized void disconnect() throws Exception {
        this.root = null;
        this.activeJvm.disconnect();
        this.fireConnectionChanged();
    }

    public boolean isConnected() {
        return this.activeJvm.isConnected();
    }

    public Root getRoot() {
        return this.root;
    }

    public void loadRoot() {
        if (this.isConnected() && this.root == null) {
            try {
                this.root = NodeUtils.createObjectNameTree((IConnectionWrapper)this);
                for (Runnable task : this.afterLoadRunnables) {
                    task.run();
                }
                this.afterLoadRunnables.clear();
            }
            catch (Throwable e) {
                Activator.getLogger().warning("Failed to load JMX tree for " + this + ". " + e, e);
            }
        }
    }

    public void run(IJMXRunnable runnable) throws CoreException {
        try {
            runnable.run(this.getConnection());
        }
        catch (JMXException ce) {
            Status s = new Status(4, "com.fusesource.ide.jmx.core", JMXCoreMessages.DefaultConnection_ErrorRunningJMXCode, (Throwable)ce);
            throw new CoreException((IStatus)s);
        }
    }

    public boolean canControl() {
        return true;
    }

    protected void fireConnectionChanged() {
        DefaultConnectionProvider provider = (DefaultConnectionProvider)this.getProvider();
        provider.fireChanged((IConnectionWrapper)this);
    }

    public IConnectionProvider getProvider() {
        return ExtensionManager.getProvider((String)"com.fusesource.ide.jmx.core.providers.DefaultConnectionProvider");
    }

    public RefreshableUI getRefreshableUI() {
        return this.parent.getRefreshableUI();
    }

    public boolean isKaraf(String rootDir) {
        String displayName = this.activeJvm.getMainClass();
        return Objects.equal((Object)"org.apache.karaf.main.Main", (Object)displayName);
    }

    public String getName() {
        if (this.name == null) {
            String displayName = this.activeJvm.getMainClass();
            if (Strings.isBlank((String)displayName)) {
                displayName = "Java process";
            } else if (displayName.startsWith(MAVEN_PREFIX)) {
                int start;
                String pInfo;
                if ((displayName = "maven" + displayName.substring(MAVEN_PREFIX.length())).endsWith("org.apache.camel:camel-maven-plugin:run") || displayName.endsWith("camel:run")) {
                    displayName = "Local Camel Context";
                    this.image = JMXUIActivator.getDefault().getImage("camel.png");
                } else if (!this.activeJvm.isRemote() && (pInfo = this.queryProcessInformation(this.activeJvm.getPid())) != null && (start = pInfo.indexOf(ECLIPSE_MAVEN_PROCESS_PREFIX)) != -1) {
                    int end = pInfo.indexOf(ECLIPSE_MAVEN_PROCESS_POSTFIX, start + ECLIPSE_MAVEN_PROCESS_PREFIX.length() + 1);
                    displayName = end != -1 ? pInfo.substring(start + ECLIPSE_MAVEN_PROCESS_PREFIX.length(), end) : pInfo.substring(start + ECLIPSE_MAVEN_PROCESS_PREFIX.length());
                }
            } else if (this.isKaraf(displayName)) {
                File[] jars;
                File libFolder;
                int end;
                int start;
                String pInfo;
                String karafHomeFolder = null;
                if (!this.activeJvm.isRemote() && (pInfo = this.queryProcessInformation(this.activeJvm.getPid())) != null && (start = pInfo.indexOf(KARAF_HOME_PREFIX)) != -1 && (end = pInfo.indexOf(KARAF_HOME_POSTFIX, start + KARAF_HOME_PREFIX.length() + 1)) != -1) {
                    karafHomeFolder = pInfo.substring(start + KARAF_HOME_PREFIX.length(), end);
                }
                String karafSubType = null;
                if (karafHomeFolder != null && (libFolder = new File(String.format("%s%slib%s", karafHomeFolder, File.separator, File.separator))).exists() && libFolder.isDirectory() && (jars = libFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        return f.isFile() && f.getName().toLowerCase().endsWith("-version.jar");
                    }
                })) != null && jars.length == 1) {
                    File f = jars[0];
                    karafSubType = karafSubTypeMap.containsKey(f.getName()) ? karafSubTypeMap.get(f.getName()) : karafSubTypeMap.get("default");
                }
                if (karafSubType != null && karafSubType.toLowerCase().contains("fuse")) {
                    this.image = JMXUIActivator.getDefault().getImage("container.png");
                }
                displayName = karafSubType == null ? this.getNameFromAliasMap(displayName) : karafSubType;
            } else {
                displayName = this.getNameFromAliasMap(displayName);
            }
            this.name = displayName = String.valueOf(displayName) + " [" + this.activeJvm.getPid() + "]";
        }
        return this.name;
    }

    private String getNameFromAliasMap(String displayName) {
        Set<Map.Entry<String, String>> entrySet = vmAliasMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String key = entry.getKey();
            if (!displayName.startsWith(key)) continue;
            return String.valueOf(entry.getValue()) + displayName.substring(key.length());
        }
        return displayName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Image getImage() {
        String n = this.getName();
        if (this.image == null && n != null && n.contains("Camel")) {
            this.image = JMXUIActivator.getDefault().getImage("camel.png");
        }
        if (this.image != null) {
            return this.image;
        }
        return JMXUIActivator.getDefault().getImage("container.gif");
    }

    public Properties getAgentProperties() {
        return new Properties();
    }

    public Map<String, String> getSystemProperties() {
        return System.getenv();
    }

    private String queryProcessInformation(int pid) {
        String retVal = null;
        if (!processInformationStore.containsKey(pid)) {
            JvmConnectionWrapper.refreshProcessInformationStore();
        }
        retVal = processInformationStore.get(pid);
        return retVal;
    }

    public static void refreshProcessInformationStore() {
        block18: {
            processInformationStore.clear();
            String path = String.format("%s%sbin%s", System.getProperty("java.home"), File.separator, File.separator);
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add("jps");
            cmds.add("-v");
            ProcessBuilder pb = new ProcessBuilder(cmds);
            pb.directory(new File(path));
            BufferedReader br = null;
            try {
                try {
                    Process p = pb.start();
                    br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String line = "";
                    while ((line = br.readLine()) != null) {
                        StringTokenizer st = new StringTokenizer(line, KARAF_HOME_POSTFIX);
                        int pid = -1;
                        if (st.hasMoreElements()) {
                            String sVal = st.nextToken();
                            try {
                                pid = Integer.parseInt(sVal);
                            }
                            catch (NumberFormatException numberFormatException) {
                                pid = -1;
                            }
                        }
                        if (pid == -1) continue;
                        processInformationStore.put(pid, line);
                    }
                }
                catch (Exception exception) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Exception exception2) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

