/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jmx.ui.internal.localjmx;

import com.fusesource.ide.jmx.core.tree.HasRoot;
import com.fusesource.ide.jmx.core.tree.Root;
import com.fusesource.ide.jmx.ui.JMXUIActivator;
import com.fusesource.ide.jmx.ui.internal.localjmx.JvmConnectionWrapper;
import com.fusesource.ide.jmx.ui.internal.localjmx.JvmKey;
import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.IHost;
import com.fusesource.ide.jvmmonitor.core.IJvmModelChangeListener;
import com.fusesource.ide.jvmmonitor.core.JvmModel;
import com.fusesource.ide.jvmmonitor.core.JvmModelEvent;
import com.fusesource.ide.jvmmonitor.core.mbean.IMBeanServer;
import com.fusesource.rider.commons.tree.HasRefreshableUI;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.PartialRefreshableNode;
import com.fusesource.rider.commons.tree.RefreshableUI;
import java.util.List;
import javax.management.remote.JMXServiceURL;

public class JvmConnectionsNode
extends PartialRefreshableNode<JvmKey, JvmConnectionWrapper>
implements HasRefreshableUI,
HasRoot {
    private final Root root;
    private final RefreshableUI contentProvider;
    private IJvmModelChangeListener listener;

    public static JvmConnectionWrapper createKarafConnection(String rootDir) {
        return JvmConnectionsNode.createKarafConnection(rootDir, "JMX");
    }

    public static JvmConnectionWrapper createKarafConnection(String rootDir, String name) {
        JvmConnectionsNode collection = new JvmConnectionsNode(null, null);
        JvmConnectionWrapper answer = collection.getKarafVMConnection(rootDir);
        if (answer != null) {
            answer.setName(name);
        }
        return answer;
    }

    public JvmConnectionsNode(Root root, RefreshableUI contentProvider) {
        super((Node)root);
        this.root = root;
        this.contentProvider = contentProvider;
    }

    public Root getRoot() {
        return this.root;
    }

    public String toString() {
        return "Local Processes";
    }

    public RefreshableUI getRefreshableUI() {
        if (this.contentProvider instanceof RefreshableUI) {
            return this.contentProvider;
        }
        return super.getRefreshableUI();
    }

    protected Object[] doLoadChildren() {
        try {
            JvmModel model = JvmModel.getInstance();
            if (this.listener == null) {
                this.listener = new IJvmModelChangeListener(){

                    public void jvmModelChanged(JvmModelEvent e) {
                        JvmConnectionsNode.this.refresh();
                    }
                };
                model.addJvmModelChangeListener(this.listener);
            }
            List hosts = model.getHosts();
            for (IHost host : hosts) {
                String hostName = host.getName();
                List jvms = host.getActiveJvms();
                for (IActiveJvm jvm : jvms) {
                    int pid = jvm.getPid();
                    JvmKey key = new JvmKey(hostName, pid);
                    JvmConnectionWrapper connectionWrapper = (JvmConnectionWrapper)this.getChild(key);
                    if (connectionWrapper != null) {
                        connectionWrapper.setActiveJvm(jvm);
                        this.nodeStillExists(connectionWrapper);
                        continue;
                    }
                    IMBeanServer mbeanServer = jvm.getMBeanServer();
                    JMXServiceURL jmxUrl = mbeanServer.getJmxUrl();
                    if (jmxUrl == null) continue;
                    connectionWrapper = new JvmConnectionWrapper(this, jmxUrl, jvm);
                    this.addChild(key, connectionWrapper);
                }
            }
        }
        catch (Throwable e) {
            JvmConnectionsNode.error(e);
        }
        return this.list.toArray();
    }

    public JvmConnectionWrapper getKarafVMConnection(String rootDir) {
        int i = 0;
        while (i < 2) {
            Object[] array;
            if (i > 0) {
                this.refresh();
            }
            Object[] objectArray = array = this.getChildObjectArray();
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                JvmConnectionWrapper vmc;
                Object node = objectArray[n2];
                if (node instanceof JvmConnectionWrapper && (vmc = (JvmConnectionWrapper)node).isKaraf(rootDir)) {
                    return vmc;
                }
                ++n2;
            }
            ++i;
        }
        return null;
    }

    private static void info(String text) {
        JMXUIActivator.getLogger().info(text);
    }

    private static void error(Throwable t) {
        JMXUIActivator.getLogger().warning(t);
        Throwable cause = t.getCause();
        if (cause != null) {
            JMXUIActivator.getLogger().warning("Cause: " + cause, cause);
        }
    }
}

