// Function to add a listener to an object in the DOM
// Needs two versions so it works on all browsers 

function addEvent(obj, evType, fn){ 
 if (obj.addEventListener) { 
   obj.addEventListener(evType, fn, false); 
   return true; 
 } else if (obj.attachEvent){ 
   var r = obj.attachEvent("on"+evType, fn); 
   return r; 
 } else { 
   return false; 
 } 
}

// Return an array of all the elements of a given classname that are children of
// the node passed in

function getElementsByClassName(node, classname) {
  var a = [];
  var re = new RegExp('\\b' + classname + '\\b');
  var els = node.getElementsByTagName("*");
  for(var i=0,j=els.length; i<j; i++) {
    if(re.test(els[i].className)) {a.push(els[i]);}
  }
  return a; 
}

// Show elements of class 'needsjavascript'
// The page's stylesheet should set these to be display:none
// They will then not display unless javascript is enabled

function showJavascriptElements() {
  var needjs=getElementsByClassName(document,"needsjavascript");
  for (var i=0; i<needjs.length; i++) {
    needjs[i].className="";
  }
}

addEvent(window, 'load', showJavascriptElements);

// To avoid web spiders harvesting plain-text e-mail addresses,
// this function obfuscates the address to which document 
// error reports are sent. This code is modified from the 
// code generated by http://www.closetnoc.com/mungemaster/mungemaster.pl
function sendMail()
{
var prkaaaiwpppwj = "om;"// "&#111;&#109;";
var wog8kalwl = "pport"; // "&#112;p&#111;&#114;t";
var gBniHikxFvQRegGuZnFXZwEiIGL = "@"; "&#64;";
var FiXXnFJMDOgnPzh="docs-su"; // "&#100;&#111;c&#115;&#45;s&#117;";
var juQUXxDNmnACEKwnFhHYBVZHdIInjVQv = "fusesource.c"; //"&#105;&#111;n&#97;&#46;c";
var TextWithLocation = "Feedback%20on%20" + document.URL;
var sendto="mailto:" +FiXXnFJMDOgnPzh +wog8kalwl 
  +gBniHikxFvQRegGuZnFXZwEiIGL 
  +juQUXxDNmnACEKwnFhHYBVZHdIInjVQv +prkaaaiwpppwj
  + "?subject=Documentation%20Feedback" 
  + "&"
  + "body=" + TextWithLocation;
document.location.assign(sendto);
}
