/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.tooling.fuse.cdc;

import com.fusesource.tooling.fuse.cdc.api.Configuration;
import com.fusesource.tooling.fuse.cdc.api.CustomDistributionCreator;
import com.fusesource.tooling.fuse.cdc.api.aether.RepositorySystemFactory;
import com.fusesource.tooling.fuse.cdc.api.aether.RepositorySystemSessionFactory;
import com.fusesource.tooling.fuse.cdc.api.resolver.RepositoryConfiguration;
import com.fusesource.tooling.fuse.cdc.api.resolver.ResolverUtils;
import com.fusesource.tooling.fuse.cdc.api.utils.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public class FuseCDCCLI {
    public static final String ORIG_DISTRO_KEY = "original.distribution.artifact";
    public static final String FEATURE_DESCRIPTOR_KEY = "feature.descriptors";
    public static final String FEATURE_NAMES_KEY = "features.names";
    private static final Logger LOGGER = LoggerFactory.getLogger(FuseCDCCLI.class);
    private static final String USAGE = "[-p]";
    private static final String HEADER = "FuseCDC - Fuse Custom Distribution Creator, Copyright 2012 FuseSource, Corp. All rights reserved.";
    private static final String FOOTER = "For more details, see our website at: http://fusesource.com";
    private String outputDirectory = "build";
    private final List<String> defaultFeatures = new ArrayList<String>();

    public FuseCDCCLI() {
        this.defaultFeatures.add("karaf-framework");
        this.defaultFeatures.add("jasypt-encryption");
        this.defaultFeatures.add("config");
        this.defaultFeatures.add("management");
        this.defaultFeatures.add("fabric-boot-commands");
        this.defaultFeatures.add("fabric-bundle");
        this.defaultFeatures.add("patch");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(String propertyFileName) throws Exception {
        String[] features;
        Properties props = this.loadProperties(propertyFileName);
        for (Object objKey : props.keySet()) {
            String key = (String)objKey;
            if (!key.startsWith("maven.wagon")) continue;
            String value = props.getProperty(key);
            System.setProperty(key, value);
        }
        if (System.getProperty("maven.wagon.rto") == null) {
            System.setProperty("maven.wagon.rto", "30000");
        }
        Configuration c = new Configuration();
        DefaultArtifact distro = new DefaultArtifact(ResolverUtils.toArtifactCoords(props.getProperty(ORIG_DISTRO_KEY)));
        c.setDistributionArtifact(distro);
        if (props.containsKey(FEATURE_DESCRIPTOR_KEY)) {
            ArrayList<String> featureDescriptors = new ArrayList<String>();
            for (String feature : features = ((String)props.get(FEATURE_DESCRIPTOR_KEY)).split(",")) {
                featureDescriptors.add(feature);
            }
            c.setDescriptors(featureDescriptors);
        }
        ArrayList<String> featureNames = new ArrayList<String>();
        if (props.containsKey(FEATURE_NAMES_KEY)) {
            if (ObjectUtils.isStringEmpty(FEATURE_NAMES_KEY)) {
                featureNames.add("default");
            } else if (!props.containsKey("all")) {
                featureNames.addAll(this.defaultFeatures);
                for (String feature : features = ((String)props.get(FEATURE_NAMES_KEY)).split(",")) {
                    if (featureNames.contains(feature)) continue;
                    featureNames.add(feature);
                }
            }
        }
        c.setFeatures(featureNames);
        if (ObjectUtils.isStringNotEmpty(props.getProperty("build.output.directory"))) {
            c.setBuildDirectory(new File(props.getProperty("build.output.directory")));
        } else {
            c.setBuildDirectory(new File(this.getOutputDirectory()));
        }
        if (ObjectUtils.isStringNotEmpty(props.getProperty("distribution.create"))) {
            c.setRepackage(Boolean.parseBoolean(props.getProperty("distribution.create")));
            if (ObjectUtils.isStringNotEmpty(props.getProperty("distribution.output.directory"))) {
                c.setDistributionDirectory(new File(props.getProperty("distribution.output.directory")));
            } else {
                c.setDistributionDirectory(new File("dist"));
            }
            if (ObjectUtils.isStringNotEmpty(props.getProperty("distribution.output.final.name"))) {
                c.setRepackagedFileName(props.getProperty("distribution.output.final.name"));
            } else {
                String newOutputFileName = propertyFileName.substring(0, propertyFileName.lastIndexOf("."));
                newOutputFileName = newOutputFileName.replace('.', '-');
                c.setRepackagedFileName(newOutputFileName);
            }
        } else {
            c.setRepackage(false);
        }
        RepositorySystem system = RepositorySystemFactory.newRepositorySystem();
        c.setRepositorySystem(system);
        RepositorySystemSession session = null;
        String localRepo = props.getProperty("local.repository");
        if (ObjectUtils.isStringNotEmpty(localRepo)) {
            File localRepoDirectory = new File(localRepo);
            if (!localRepoDirectory.exists()) {
                localRepoDirectory.mkdirs();
            }
            if (!localRepoDirectory.exists() || !new File(localRepo).canWrite()) throw new Exception("Unable to create the local repository defined by property local.repository: " + localRepo);
            session = RepositorySystemSessionFactory.newRepositorySystemSession(system, localRepo);
        } else {
            session = RepositorySystemSessionFactory.newRepositorySystemSession(system, "repository");
        }
        c.setRepositorySystemSession(session);
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
        int repositoryKeyNumber = 1;
        String repositoryKey = "repository." + repositoryKeyNumber;
        while (props.containsKey(repositoryKey)) {
            RepositoryConfiguration rc = this.createRepositoryConfiguration(props, repositoryKeyNumber);
            remoteRepositories.add(ResolverUtils.createRepository(rc));
            repositoryKey = "repository." + ++repositoryKeyNumber;
        }
        c.setRemoteRepositories(remoteRepositories);
        CustomDistributionCreator dc = new CustomDistributionCreator(c);
        try {
            dc.execute();
            return;
        }
        catch (Exception e) {
            LOGGER.error("Exception", e);
        }
    }

    private RepositoryConfiguration createRepositoryConfiguration(Properties props, int repositoryKeyNumber) throws Exception {
        String proxyKey;
        String snapshots;
        RepositoryConfiguration rc = new RepositoryConfiguration();
        String url = props.getProperty("repository." + repositoryKeyNumber + ".url");
        if (ObjectUtils.isStringNotEmpty(url)) {
            try {
                new URL(url);
            }
            catch (Exception e) {
                throw new Exception(e.getLocalizedMessage(), e);
            }
        } else {
            throw new Exception("The repository." + repositoryKeyNumber + ".url property is empty");
        }
        rc.setUrl(url);
        String id = props.getProperty("repository." + repositoryKeyNumber);
        if (ObjectUtils.isStringNotEmpty(id)) {
            rc.setId(id);
        } else {
            rc.setId("repository." + repositoryKeyNumber);
        }
        String layout = props.getProperty("repository." + repositoryKeyNumber + ".layout");
        if (ObjectUtils.isStringNotEmpty(layout)) {
            if (layout.equalsIgnoreCase("default") || layout.equalsIgnoreCase("legacy")) {
                rc.setLayout(layout);
            } else {
                throw new Exception(String.format("Repository layout type %s is not supported", layout));
            }
        }
        String username = props.getProperty("repository." + repositoryKeyNumber + ".username", null);
        rc.setUsername(username);
        String password = props.getProperty("repository." + repositoryKeyNumber + ".password", null);
        rc.setPassword(password);
        String release = props.getProperty("repository." + repositoryKeyNumber + ".release.enabled", "true");
        if (ObjectUtils.isStringNotEmpty(release)) {
            if (release.equalsIgnoreCase("true")) {
                String releaseChecksumPolicy;
                rc.setReleaseEnabled(true);
                String releaseUpdatePolicy = props.getProperty("repository." + repositoryKeyNumber + ".release.policy.update", "daily");
                if (ObjectUtils.isStringNotEmpty(releaseUpdatePolicy)) {
                    if (releaseUpdatePolicy.equalsIgnoreCase("daily")) {
                        rc.setReleaseUpdatePolicy("daily");
                    } else if (releaseUpdatePolicy.equalsIgnoreCase("always")) {
                        rc.setReleaseUpdatePolicy("always");
                    } else if (releaseUpdatePolicy.equalsIgnoreCase("never")) {
                        rc.setReleaseUpdatePolicy("never");
                    } else {
                        LOGGER.warn("{} is not a supported repository update policy.  Please use always, daily or never.", (Object)releaseUpdatePolicy);
                    }
                }
                if (ObjectUtils.isStringNotEmpty(releaseChecksumPolicy = props.getProperty("repository." + repositoryKeyNumber + ".release.policy.checksum", "warn"))) {
                    if (releaseChecksumPolicy.equalsIgnoreCase("fail")) {
                        rc.setReleaseChecksumPolicy("fail");
                    } else if (releaseChecksumPolicy.equalsIgnoreCase("ignore")) {
                        rc.setReleaseChecksumPolicy("ignore");
                    } else if (releaseChecksumPolicy.equalsIgnoreCase("warn")) {
                        rc.setReleaseChecksumPolicy("warn");
                    } else {
                        LOGGER.warn("{} is not a supported repository checksum policy.  Please use fail, warn, ignore.", (Object)releaseChecksumPolicy);
                    }
                }
            } else {
                rc.setReleaseEnabled(false);
            }
        }
        if (ObjectUtils.isStringNotEmpty(snapshots = props.getProperty("repository." + repositoryKeyNumber + ".snapshots.enabled", "false"))) {
            if (snapshots.equalsIgnoreCase("true")) {
                String snapshotChecksumPolicy;
                rc.setSnapshotEnabled(true);
                String snapshotUpdatePolicy = props.getProperty("repository." + repositoryKeyNumber + ".snapshot.policy.update", "daily");
                if (ObjectUtils.isStringNotEmpty(snapshotUpdatePolicy)) {
                    if (snapshotUpdatePolicy.equalsIgnoreCase("daily")) {
                        rc.setSnapshotUpdatePolicy("daily");
                    } else if (snapshotUpdatePolicy.equalsIgnoreCase("always")) {
                        rc.setSnapshotUpdatePolicy("always");
                    } else if (snapshotUpdatePolicy.equalsIgnoreCase("never")) {
                        rc.setSnapshotUpdatePolicy("never");
                    } else {
                        LOGGER.warn("{} is not a supported repository update policy.  Please use always, daily or never.", (Object)snapshotUpdatePolicy);
                    }
                }
                if (ObjectUtils.isStringNotEmpty(snapshotChecksumPolicy = props.getProperty("repository." + repositoryKeyNumber + ".snapshot.policy.checksum", "warn"))) {
                    if (snapshotChecksumPolicy.equalsIgnoreCase("fail")) {
                        rc.setSnapshotChecksumPolicy("fail");
                    } else if (snapshotChecksumPolicy.equalsIgnoreCase("ignore")) {
                        rc.setSnapshotChecksumPolicy("ignore");
                    } else if (snapshotChecksumPolicy.equalsIgnoreCase("warn")) {
                        rc.setSnapshotChecksumPolicy("warn");
                    } else {
                        LOGGER.warn("{} is not a supported repository checksum policy.  Please use fail, warn, ignore.", (Object)snapshotChecksumPolicy);
                    }
                }
            } else {
                rc.setReleaseEnabled(false);
            }
        }
        if (props.containsKey(proxyKey = "http.proxy")) {
            URI proxyUri = new URI(props.getProperty(proxyKey));
            rc.setProxyUri(proxyUri);
        }
        return rc;
    }

    private Properties loadProperties(String propertyFileName) throws IOException {
        Properties props = null;
        try {
            ClassLoader cl = FuseCDCCLI.class.getClassLoader();
            InputStream cdcConfigStream = cl.getResourceAsStream(propertyFileName);
            props = new Properties();
            props.load(cdcConfigStream);
        }
        catch (Exception e) {
            LOGGER.error("Unable to load profile: " + propertyFileName);
            LOGGER.debug("  Cause: " + e.getLocalizedMessage(), e);
        }
        return props;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("h", "help", false, "Print usage information");
        options.addOption("p", "profile", true, "The name of a file that containing property overrides for the default.profile. The file must be located under the etc directory.");
        String propertyFileName = null;
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption('h')) {
                FuseCDCCLI.printUsage(options);
                System.exit(0);
            }
            propertyFileName = line.hasOption("profile") ? line.getOptionValue("profile") : "default.profile";
        }
        catch (ParseException e) {
            System.out.println(e.getLocalizedMessage());
            FuseCDCCLI.printUsage(options);
            System.exit(100);
        }
        FuseCDCCLI cdc = new FuseCDCCLI();
        try {
            cdc.execute(propertyFileName);
        }
        catch (Exception e) {
            LOGGER.error("Error creating distribution: {}" + e.getLocalizedMessage(), e);
            System.exit(200);
        }
    }

    private static void printUsage(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(80);
        helpFormatter.printHelp(USAGE, HEADER, options, FOOTER);
    }
}

