/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.tooling.fuse.cdc.api;

import com.fusesource.tooling.fuse.cdc.api.Configuration;
import com.fusesource.tooling.fuse.cdc.api.NoSuchDistributionException;
import com.fusesource.tooling.fuse.cdc.api.archive.ArtifactArchiveUtil;
import com.fusesource.tooling.fuse.cdc.api.resolver.Resolver;
import com.fusesource.tooling.fuse.cdc.api.resolver.ResolverUtils;
import com.fusesource.tooling.fuse.cdc.api.utils.FileUtils;
import com.fusesource.tooling.fuse.cdc.api.utils.ObjectUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.internal.RepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public class CustomDistributionCreator {
    private static final Logger LOG = LoggerFactory.getLogger(CustomDistributionCreator.class);
    public static final String FEATURE_CONFIG_LOCATION = "etc/org.apache.karaf.features.cfg";
    public static final String FEATURES_REPOSITORIES_KEY = "featuresRepositories";
    public static final String FEATURES_BOOT_KEY = "featuresBoot";
    private final Configuration configuration;
    private Resolver resolver;
    private Map<String, Feature> featureCache = new HashMap<String, Feature>();
    private Map<String, String> bundleLocationCache = new HashMap<String, String>();

    public CustomDistributionCreator(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("The configuration argument man not be null");
        }
        this.configuration = configuration;
        this.resolver = new Resolver(configuration);
    }

    private void printConfig() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Distribution Configuration: ");
            LOG.debug(" Distribution Artifact  : {}", (Object)this.configuration.getDistributionArtifact().toString());
            LOG.debug(" Output Directory       :" + this.configuration.getBuildDirectory().getAbsolutePath());
            LOG.debug(" Feature Descriptors    :" + this.configuration.getDescriptors());
            LOG.debug(" Feature Names          :" + this.configuration.getFeatures());
            LOG.debug(" Repackage              :" + this.configuration.isRepackage());
            LOG.debug(" Repackage Directory    :" + this.configuration.getDistributionDirectory().getAbsolutePath());
            LOG.debug(" Repackage Name         :" + this.configuration.getRepackagedFileName());
        }
    }

    public void execute() throws Exception {
        Object[] bootFeatures;
        LOG.info("Execute Customization");
        FileUtils.delete(this.configuration.getBuildDirectory());
        this.printConfig();
        Artifact distroArtifact = this.resolveDistribution();
        File distro = this.extractDistributionArtifact(distroArtifact);
        File repository = new File(distro, "system");
        if (!repository.exists()) {
            throw new FileNotFoundException("The system directory does not exist for distribution " + distro.getAbsolutePath());
        }
        Map<String, String> featureCfgMap = this.getFeatureCfgMap(distro);
        List<String> distroFeatureDescriptorLocations = this.retrieveDistributionFeatureDescriptors(distro, featureCfgMap);
        for (String featureDescriptor : distroFeatureDescriptorLocations) {
            if (ObjectUtils.isListEmpty(this.configuration.getDescriptors())) {
                this.configuration.setDescriptors(new ArrayList<String>());
            }
            if (this.configuration.getDescriptors().contains(featureDescriptor)) continue;
            this.configuration.getDescriptors().add(featureDescriptor.trim());
        }
        for (String uri : this.configuration.getDescriptors()) {
            this.resolveDescriptors(repository, uri);
        }
        if ((this.configuration.getFeatures() == null || this.configuration.getFeatures().isEmpty()) && ObjectUtils.isArrayNotEmpty(bootFeatures = featureCfgMap.get(FEATURES_BOOT_KEY).split(","))) {
            ArrayList<String> defaultFeatures = new ArrayList<String>();
            for (Object bootFeature : bootFeatures) {
                defaultFeatures.add((String)bootFeature);
            }
            this.configuration.setFeatures(defaultFeatures);
        }
        this.resolveBundleLocations(this.configuration.getFeatures());
        LOG.info("Adding Artifacts to the distribution system repository");
        for (String bundle : this.bundleLocationCache.keySet()) {
            if (bundle.startsWith("blueprint")) {
                LOG.warn("  Artifact URI type blueprint is unsupported.  Skipping bundle {}.", (Object)bundle);
                continue;
            }
            if (bundle.startsWith("file")) {
                LOG.warn("  Artifact URI type file is unsupported. Skipping bundle {}.", (Object)bundle);
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("  Adding : " + bundle);
            }
            this.resolveBundle(bundle, repository);
        }
        this.featureConfigWriter(distro);
        if (this.configuration.isRepackage()) {
            File finalOutputDir = null;
            finalOutputDir = this.configuration.getDistributionDirectory() == null ? this.configuration.getBuildDirectory() : this.configuration.getDistributionDirectory();
            File archive = ArtifactArchiveUtil.archive(distro, finalOutputDir, this.configuration.getDistributionArtifact().getExtension());
            FileUtils.delete(distro);
            if (ObjectUtils.isStringNotEmpty(this.configuration.getRepackagedFileName())) {
                String newFileName = this.configuration.getRepackagedFileName() + "." + this.configuration.getDistributionArtifact().getExtension();
                LOG.info("Moving file to {}", (Object)newFileName);
                FileInputStream fis = new FileInputStream(archive);
                FileOutputStream fos = new FileOutputStream(new File(finalOutputDir, newFileName));
                IOUtils.copy(fis, fos);
                fis.close();
                fos.flush();
                fos.close();
                FileUtils.delete(archive);
            }
        }
    }

    private List<String> retrieveDistributionFeatureDescriptors(File distro, Map<String, String> featuresCfgMap) throws FileNotFoundException, IOException {
        List<String> descriptorList = null;
        String defaultDescriptorProp = featuresCfgMap.get(FEATURES_REPOSITORIES_KEY);
        Object[] defaultDescriptors = defaultDescriptorProp.split(",");
        if (LOG.isTraceEnabled()) {
            for (Object descriptor : defaultDescriptors) {
                LOG.trace("    {}" + (String)descriptor);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("  Loading the return array");
        }
        if (ObjectUtils.isArrayEmpty(defaultDescriptors)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("    No default descriptors found.  Returning empty List.");
            }
            descriptorList = Collections.emptyList();
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.trace("    Descriptors found.");
            }
            descriptorList = new ArrayList<Object>(Arrays.asList(defaultDescriptors));
            if (LOG.isTraceEnabled()) {
                for (Object descriptor : defaultDescriptors) {
                    LOG.trace("    {}", descriptor);
                }
            }
        }
        return descriptorList;
    }

    private Map<String, String> getFeatureCfgMap(File distro) throws IOException {
        HashMap<String, String> featureCfgMap = new HashMap<String, String>();
        LOG.info("Loading distribution feature configuration");
        if (LOG.isDebugEnabled()) {
            LOG.debug("  Load properties from {}", (Object)FEATURE_CONFIG_LOCATION);
        }
        Properties defaultFeatureProperties = new Properties();
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(distro, FEATURE_CONFIG_LOCATION)));
        defaultFeatureProperties.load(bis);
        bis.close();
        if (LOG.isTraceEnabled()) {
            Set<Object> keys = defaultFeatureProperties.keySet();
            LOG.trace("  Feature Configuration Properties");
            for (Object key : keys) {
                LOG.trace("    Property Pair : {}={}", key, (Object)defaultFeatureProperties.getProperty((String)key));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("  Splitting the featureRepositories property");
        }
        featureCfgMap.put(FEATURES_REPOSITORIES_KEY, defaultFeatureProperties.getProperty(FEATURES_REPOSITORIES_KEY));
        featureCfgMap.put(FEATURES_BOOT_KEY, defaultFeatureProperties.getProperty(FEATURES_BOOT_KEY));
        return featureCfgMap;
    }

    private File extractDistributionArtifact(Artifact distroArtifact) throws FileNotFoundException, IOException, ArchiveException, CompressorException {
        LOG.info("Extracting...");
        File distro = ArtifactArchiveUtil.unarchive(distroArtifact.getFile(), this.configuration.getBuildDirectory());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracted Distribution Location : {}", (Object)distro.getAbsolutePath());
        }
        return distro;
    }

    private Artifact resolveDistribution() throws NoSuchDistributionException {
        Artifact dist = this.configuration.getDistributionArtifact();
        Object[] args = new Object[]{dist.getGroupId(), dist.getArtifactId(), dist.getVersion(), dist.getExtension()};
        LOG.info("Resolving Distribution: {}:{}:{}:{}", args);
        List<ArtifactResult> results = this.resolver.resolveArtifact(this.configuration.getDistributionArtifact());
        if (ObjectUtils.isListEmpty(results)) {
            throw new NoSuchDistributionException("No distribution was found for the target artifact: " + this.configuration.getDistributionArtifact().toString());
        }
        Artifact distroArtifact = results.get(0).getArtifact();
        return distroArtifact;
    }

    private void resolveDescriptors(File repository, String uri) throws Exception {
        Artifact descriptor = null;
        if (uri != null) {
            descriptor = this.resolveBundle(uri, repository);
        }
        RepositoryImpl repo = new RepositoryImpl(descriptor.getFile().toURI());
        for (Feature f : repo.getFeatures()) {
            this.featureCache.put(f.getName() + "/" + f.getVersion(), f);
        }
        Object[] definedRepos = repo.getRepositories();
        if (ObjectUtils.isArrayNotEmpty(definedRepos)) {
            for (Object r : definedRepos) {
                this.resolveDescriptors(repository, ((URI)r).toString());
            }
        }
    }

    private Artifact resolveBundle(String uri, File repository) throws IOException {
        Artifact descriptor = null;
        DefaultArtifact da = new DefaultArtifact(ResolverUtils.toArtifactCoords(uri));
        Object[] args = new Object[]{da.getExtension().toUpperCase(), da.getGroupId(), da.getArtifactId(), da.getVersion()};
        LOG.info("Fetching {}: {}:{}:{}", args);
        String dedicatedRepository = null;
        if (uri.startsWith("mvn:http://")) {
            String repoUrl;
            int repoDelimIntex = uri.indexOf(33);
            dedicatedRepository = repoUrl = uri.substring(4, repoDelimIntex);
            uri = "mvn:" + uri.substring(repoDelimIntex + 1);
        }
        List<ArtifactResult> results = null;
        results = ObjectUtils.isStringEmpty(dedicatedRepository) ? this.resolver.resolveArtifact((Artifact)da, dedicatedRepository) : this.resolver.resolveArtifact(da);
        if (ObjectUtils.isListNotEmpty(results)) {
            if (results.size() > 1) {
                LOG.warn("The resolver returned more than one result: " + results);
            }
            descriptor = results.get(0).getArtifact();
            String dir = descriptor.getGroupId().replace('.', '/') + "/" + descriptor.getArtifactId() + "/" + descriptor.getBaseVersion() + "/";
            String name = descriptor.getArtifactId() + "-" + descriptor.getBaseVersion() + (ObjectUtils.isStringNotEmpty(descriptor.getClassifier()) ? "-" + descriptor.getClassifier() : "") + "." + descriptor.getExtension();
            LOG.info("Copying {} to the System Repository.", (Object)name);
            CustomDistributionCreator.copy(new FileInputStream(results.get(0).getArtifact().getFile()), repository, name, dir, new byte[8192]);
        }
        return descriptor;
    }

    public static void copy(InputStream is, File dir, String destName, String destDir, byte[] buffer) throws IOException {
        File destinationFile;
        File targetDir;
        if (destDir == null) {
            destDir = "";
        }
        if (!(targetDir = new File(dir, destDir)).exists()) {
            if (!targetDir.mkdirs()) {
                throw new IOException("Unable to create target directory: " + targetDir);
            }
        } else if (!targetDir.isDirectory()) {
            throw new IOException("Target is not a directory: " + targetDir);
        }
        if (!(destinationFile = new File(targetDir, destName)).exists()) {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destinationFile));
            int count = 0;
            while ((count = is.read(buffer)) > 0) {
                bos.write(buffer, 0, count);
            }
            bos.close();
        }
    }

    private void resolveBundleLocations(List<String> features) {
        for (String feature : features) {
            LOG.info("Adding Artifacts for feature: {}", (Object)feature);
            Feature f = null;
            int delimIndex = feature.indexOf(47);
            if (delimIndex > 0) {
                String featureKey = feature.substring(0, delimIndex) + "/" + feature.substring(delimIndex + 1);
                f = this.featureCache.get(featureKey);
            } else {
                for (String key : this.featureCache.keySet()) {
                    String[] nameVersion = key.split("/");
                    if (!feature.equals(nameVersion[0]) || f != null && f.getVersion().compareTo(this.featureCache.get(key).getVersion()) >= 0) continue;
                    f = this.featureCache.get(key);
                }
            }
            if (f == null) {
                throw new IllegalArgumentException("Unable to find the feature '" + feature + "'");
            }
            if (ObjectUtils.isListNotEmpty(f.getDependencies())) {
                for (Feature transitiveFeature : f.getDependencies()) {
                    String value = transitiveFeature.getName();
                    if (this.bundleLocationCache.containsValue(value)) continue;
                    ArrayList<String> transitiveFeaturesNames = new ArrayList<String>();
                    transitiveFeaturesNames.add(transitiveFeature.getName());
                    this.resolveBundleLocations(transitiveFeaturesNames);
                }
            }
            for (BundleInfo bundleInfo : f.getBundles()) {
                String key = bundleInfo.getLocation();
                String value = f.getName();
                if (!this.bundleLocationCache.containsKey(key)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("  Adding BundleInfo for Feature   : {} : {}", (Object)(f.getName() + "/" + f.getVersion()), (Object)bundleInfo.getLocation());
                    }
                    this.bundleLocationCache.put(key, value);
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("  Skipping BundleInfo for Feature : {} : {}", (Object)(f.getName() + "/" + f.getVersion()), (Object)bundleInfo.getLocation());
            }
        }
    }

    private void featureConfigWriter(File distroDir) throws FileNotFoundException, IOException {
        FileUtils.move(new File(distroDir, FEATURE_CONFIG_LOCATION), new File(distroDir, "etc/org.apache.karaf.features.bak"));
        File newCfg = new File(distroDir, FEATURE_CONFIG_LOCATION);
        ClassLoader cl = CustomDistributionCreator.class.getClassLoader();
        BufferedReader br = new BufferedReader(new InputStreamReader(cl.getResourceAsStream("org.apache.karaf.features.cfg")));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(newCfg)));
        String line = br.readLine();
        while (line != null) {
            if (line.contains("featuresRepositories=")) {
                StringBuilder descriptorsLine = new StringBuilder("featuresRepositories=");
                for (String featureDescriptor : this.configuration.getDescriptors()) {
                    descriptorsLine.append(featureDescriptor + ",");
                }
                String descriptors = descriptorsLine.substring(0, descriptorsLine.length() - 1);
                bw.write(descriptors + "\n");
            } else if (line.contains("featuresBoot=")) {
                StringBuilder featuresLine = new StringBuilder("featuresBoot=");
                for (String feature : this.configuration.getFeatures()) {
                    featuresLine.append(feature + ",");
                }
                String features = featuresLine.substring(0, featuresLine.length() - 1);
                bw.write(features + "\n");
            } else {
                bw.write(line + "\n");
            }
            line = br.readLine();
        }
        br.close();
        bw.flush();
        bw.close();
    }
}

