/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.tooling.fuse.cdc.api.aether;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;

public class DependencyGraphLogger
implements DependencyVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyGraphLogger.class);
    private String currentIndent = "";

    @Override
    public boolean visitEnter(DependencyNode node) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.currentIndent + node);
        }
        this.currentIndent = this.currentIndent.length() <= 0 ? "+- " : "|  " + this.currentIndent;
        return true;
    }

    @Override
    public boolean visitLeave(DependencyNode node) {
        this.currentIndent = this.currentIndent.substring(3, this.currentIndent.length());
        return true;
    }
}

