/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.tooling.fuse.cdc.api.aether;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.AbstractRepositoryListener;
import org.sonatype.aether.RepositoryEvent;

public class RepositoryListenerLogger
extends AbstractRepositoryListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryListenerLogger.class);

    @Override
    public void artifactDeployed(RepositoryEvent event) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.debug("  Deployed {} to {}", event.getArtifact(), (Object)event.getRepository());
        }
    }

    @Override
    public void artifactDeploying(RepositoryEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Deploying {} to {}", event.getArtifact(), (Object)event.getRepository());
        }
    }

    @Override
    public void artifactDescriptorInvalid(RepositoryEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Invalid artifact descriptor for {}: {}", event.getArtifact(), (Object)event.getException().getMessage());
        }
    }

    @Override
    public void artifactDescriptorMissing(RepositoryEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Missing artifact descriptor for ", event.getArtifact());
        }
    }

    @Override
    public void artifactInstalled(RepositoryEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Installed {} to {}", event.getArtifact(), (Object)event.getRepository());
        }
    }

    @Override
    public void artifactInstalling(RepositoryEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Installing {} to {}", event.getArtifact(), (Object)event.getRepository());
        }
    }

    @Override
    public void artifactResolved(RepositoryEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Resolved artifact {} from {}", event.getArtifact(), (Object)event.getRepository());
        }
    }

    @Override
    public void artifactDownloading(RepositoryEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Downloading artifact {} from {}", event.getArtifact(), (Object)event.getRepository());
        }
    }

    @Override
    public void artifactDownloaded(RepositoryEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Downloaded artifact {} from {}", event.getArtifact(), (Object)event.getRepository());
        }
    }

    @Override
    public void artifactResolving(RepositoryEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Resolving artifact " + event.getArtifact());
        }
    }

    @Override
    public void metadataDeployed(RepositoryEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Deployed {} to {}", event.getArtifact(), (Object)event.getRepository());
        }
    }

    @Override
    public void metadataDeploying(RepositoryEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Deploying {} to {}", event.getArtifact(), (Object)event.getRepository());
        }
    }

    @Override
    public void metadataInstalled(RepositoryEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Installed {} to {}", event.getArtifact(), (Object)event.getRepository());
        }
    }

    @Override
    public void metadataInstalling(RepositoryEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Installing {} to {}", event.getArtifact(), (Object)event.getRepository());
        }
    }

    @Override
    public void metadataInvalid(RepositoryEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Invalid metadata ", event.getMetadata());
        }
    }

    @Override
    public void metadataResolved(RepositoryEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Resolved metadata {} from {}", event.getArtifact(), (Object)event.getRepository());
        }
    }

    @Override
    public void metadataResolving(RepositoryEvent event) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Resolving metadata {} from {}", event.getArtifact(), (Object)event.getRepository());
        }
    }
}

