/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.tooling.fuse.cdc.api.aether;

import com.fusesource.tooling.fuse.cdc.api.aether.RepositoryListenerLogger;
import com.fusesource.tooling.fuse.cdc.api.aether.TransferListenerLogger;
import java.io.File;
import java.io.IOException;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.LocalRepository;

public class RepositorySystemSessionFactory {
    private static MavenRepositorySystemSession instance;
    public static final String DEFAULT_LOCAL_REPO_DIR;

    private RepositorySystemSessionFactory() {
    }

    public static synchronized RepositorySystemSession newRepositorySystemSession(RepositorySystem system) {
        return RepositorySystemSessionFactory.newRepositorySystemSession(system, DEFAULT_LOCAL_REPO_DIR);
    }

    public static synchronized RepositorySystemSession newRepositorySystemSession(RepositorySystem system, String localRepoDir) {
        if (instance == null) {
            RepositorySystemSessionFactory.createNewInstance(system, localRepoDir);
        } else {
            String currentLocalRepoDirPath = instance.getLocalRepository().getBasedir().getAbsolutePath();
            try {
                File newLocalRepo = new File(localRepoDir);
                if (!newLocalRepo.exists() && !newLocalRepo.mkdirs()) {
                    throw new IOException("Unable to create directories " + localRepoDir);
                }
                if (!currentLocalRepoDirPath.equals(newLocalRepo.getAbsolutePath())) {
                    RepositorySystemSessionFactory.createNewInstance(system, localRepoDir);
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to resolve the path for argument localRepoDir: " + localRepoDir, e);
            }
        }
        return instance;
    }

    private static void createNewInstance(RepositorySystem system, String localRepoDir) {
        instance = new MavenRepositorySystemSession();
        LocalRepository localRepo = new LocalRepository(localRepoDir);
        instance.setLocalRepositoryManager(system.newLocalRepositoryManager(localRepo));
        instance.setTransferListener(new TransferListenerLogger());
        instance.setRepositoryListener(new RepositoryListenerLogger());
    }

    static {
        DEFAULT_LOCAL_REPO_DIR = System.getProperty("user.home") + File.separator + ".m2" + File.separator + "repository";
    }
}

