/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.tooling.fuse.cdc.api.aether;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.transfer.AbstractTransferListener;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferResource;

public class TransferListenerLogger
extends AbstractTransferListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransferListenerLogger.class);
    private Map<TransferResource, Long> downloads = new ConcurrentHashMap<TransferResource, Long>();

    @Override
    public void transferInitiated(TransferEvent event) {
        TransferResource resource = event.getResource();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Transfer initiated of {}", (Object)event.getResource().getResourceName());
            LOGGER.debug("  {} : {}", (Object)this.getRequestType(event), (Object)event.getResource().getRepositoryUrl());
        }
        this.downloads.put(resource, new Long(0L));
    }

    @Override
    public void transferProgressed(TransferEvent event) {
        TransferResource resource = event.getResource();
        if (!this.downloads.containsKey(resource) || this.downloads.get(resource) == 0L) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Transfer Started");
                LOGGER.debug("  Artifact      : {}", (Object)event.getResource().getResourceName());
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("  Rsrc Location : {}", (Object)event.getResource().getRepositoryUrl());
                LOGGER.trace("  Transfer Type : {}", (Object)this.getRequestType(event));
            }
            if (LOGGER.isInfoEnabled()) {
                System.out.println(event.getResource().getResourceName());
            }
        }
        long transferred = event.getTransferredBytes();
        this.downloads.put(resource, transferred);
        if (LOGGER.isInfoEnabled()) {
            long total = resource.getContentLength();
            System.out.print("\r" + this.getStatus(transferred, total));
        }
    }

    @Override
    public void transferSucceeded(TransferEvent event) {
        this.downloads.remove(event.getResource());
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        if (contentLength > 0L) {
            String len = contentLength >= 1024L ? this.toKB(contentLength) + " KB" : contentLength + " B";
            String throughput = "";
            long duration = System.currentTimeMillis() - resource.getTransferStartTime();
            if (duration > 0L) {
                DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                double kbPerSec = (double)contentLength / 1024.0 / ((double)duration / 1000.0);
                throughput = " at " + format.format(kbPerSec) + " KB/sec";
            }
            System.out.println();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Transfer Completed");
                LOGGER.debug("  Throughput    : {}", (Object)(len + throughput));
            }
        }
    }

    @Override
    public void transferFailed(TransferEvent event) {
        this.downloads.remove(event.getResource());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Transfer Failed");
            LOGGER.debug("  Artifact         : {}", (Object)event.getResource().getResourceName());
            LOGGER.debug("  RequestType      : {} ", (Object)this.getRequestType(event));
            LOGGER.debug("  Error Message    : {} ", (Object)event.getException().getLocalizedMessage());
        }
    }

    @Override
    public void transferCorrupted(TransferEvent event) {
        this.downloads.remove(event.getResource());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Transfer Corrupted");
            LOGGER.debug("  Artifact         : {}", (Object)event.getResource().getResourceName());
            LOGGER.debug("  RequestType      : {} ", (Object)this.getRequestType(event));
            LOGGER.debug("  Error Message    : {} ", (Object)event.getException().getLocalizedMessage());
        }
    }

    private String getStatus(long complete, long total) {
        if (total >= 1024L) {
            return this.toKB(complete) + "/" + this.toKB(total) + " KB ";
        }
        if (total >= 0L) {
            return complete + "/" + total + " B ";
        }
        if (complete >= 1024L) {
            return this.toKB(complete) + " KB ";
        }
        return complete + " B ";
    }

    protected long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }

    protected String getRequestType(TransferEvent event) {
        return event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading";
    }
}

