/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.tooling.fuse.cdc.api.archive;

import com.fusesource.tooling.fuse.cdc.api.utils.FileUtils;
import com.fusesource.tooling.fuse.cdc.api.utils.ObjectUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactArchiveUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ArtifactArchiveUtil.class);
    public static final String ZIP_ARCHIVE_TYPE = "zip";
    public static final String TAR_ARCHIVE_TYPE = "tar";
    public static final String TAR_GZIP_ARCHIVE_TYPE = "tar.gz";
    public static final String GZIP_ARCHIVE_TYPE = "gz";

    public static File archive(File input, File output, String type) throws FileNotFoundException, IOException, ArchiveException, CompressorException {
        File answer = null;
        LOG.info("Creating Archive {}.{}", (Object)input.getName(), (Object)type);
        if (type.equals(TAR_GZIP_ARCHIVE_TYPE)) {
            File tar = ArtifactArchiveUtil.tar(input, output);
            answer = ArtifactArchiveUtil.gzip(tar, output);
            FileUtils.delete(tar);
        } else if (type.equals(GZIP_ARCHIVE_TYPE)) {
            answer = ArtifactArchiveUtil.gzip(input, output);
        } else if (type.equals(TAR_ARCHIVE_TYPE)) {
            answer = ArtifactArchiveUtil.tar(input, output);
        } else if (type.equals(ZIP_ARCHIVE_TYPE)) {
            answer = ArtifactArchiveUtil.zip(input, output);
        } else {
            throw new UnsupportedOperationException(String.format("The Archive with a file type of %s is unsupported", input.getName().substring(input.getName().lastIndexOf("."), 0)));
        }
        return answer;
    }

    public static File unarchive(File input, File output) throws FileNotFoundException, IOException, ArchiveException, CompressorException {
        File archiveDirectory = null;
        LOG.info("Extracting Archive {}", (Object)input.getName());
        if (!output.exists() && !output.mkdirs()) {
            throw new IOException("Unable to create the output directory: " + output.getAbsolutePath());
        }
        if (input.getName().endsWith(TAR_GZIP_ARCHIVE_TYPE)) {
            File tar = ArtifactArchiveUtil.unGzip(input, output);
            archiveDirectory = ArtifactArchiveUtil.unTar(tar, output);
        } else if (input.getName().endsWith(GZIP_ARCHIVE_TYPE)) {
            archiveDirectory = ArtifactArchiveUtil.unGzip(input, output);
        } else if (input.getName().endsWith(TAR_ARCHIVE_TYPE)) {
            archiveDirectory = ArtifactArchiveUtil.unTar(input, output);
        } else if (input.getName().endsWith(ZIP_ARCHIVE_TYPE)) {
            archiveDirectory = ArtifactArchiveUtil.unZip(input, output);
        } else {
            throw new UnsupportedOperationException(String.format("The Archive with a file type of %s is unsupported", input.getName().substring(input.getName().lastIndexOf("."), 0)));
        }
        return archiveDirectory;
    }

    private static File gzip(File inputDirectory, File outputDirectory) throws CompressorException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("  Create GZip file {}.tar.gz in dir {}.", (Object)inputDirectory.getName(), (Object)outputDirectory.getAbsolutePath());
        }
        File answer = new File(outputDirectory, inputDirectory.getName() + "." + GZIP_ARCHIVE_TYPE);
        CompressorOutputStream cos = new CompressorStreamFactory().createCompressorOutputStream(GZIP_ARCHIVE_TYPE, new FileOutputStream(answer));
        FileInputStream fis = new FileInputStream(inputDirectory);
        IOUtils.copy(fis, cos);
        fis.close();
        cos.flush();
        cos.close();
        return answer;
    }

    private static File unGzip(File inputFile, File outputDir) throws FileNotFoundException, IOException, CompressorException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("  Extract GZip file {} to dir {}.", (Object)inputFile.getAbsolutePath(), (Object)outputDir.getAbsolutePath());
        }
        File answer = new File(outputDir, inputFile.getName().substring(0, inputFile.getName().lastIndexOf(".")));
        CompressorInputStream in = new CompressorStreamFactory().createCompressorInputStream(GZIP_ARCHIVE_TYPE, new FileInputStream(inputFile));
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(answer));
        IOUtils.copy(in, bos);
        in.close();
        bos.close();
        return answer;
    }

    private static File zip(File inputDirectory, File outputDirectory) throws IOException, ArchiveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("  Create Zip file {}.zip in dir {}.", (Object)inputDirectory.getName(), (Object)outputDirectory.getAbsolutePath());
        }
        return ArtifactArchiveUtil.createArchiveFile(inputDirectory, outputDirectory, ZIP_ARCHIVE_TYPE);
    }

    private static File unZip(File inputFile, File outputDir) throws IOException, ArchiveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("  Extract Zip file {} to dir {}.", (Object)inputFile.getAbsolutePath(), (Object)outputDir.getAbsolutePath());
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(inputFile));
        File answer = new File(outputDir, inputFile.getName());
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(answer));
        IOUtils.copy(bis, bos);
        bis.close();
        bos.close();
        File zipDir = ArtifactArchiveUtil.extractArchiveFile(answer, outputDir, ZIP_ARCHIVE_TYPE);
        return zipDir;
    }

    private static File tar(File inputDirectory, File outputDirectory) throws ArchiveException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("  Create Tar file {}.tar in dir {}.", (Object)inputDirectory.getName(), (Object)outputDirectory.getAbsolutePath());
        }
        return ArtifactArchiveUtil.createArchiveFile(inputDirectory, outputDirectory, TAR_ARCHIVE_TYPE);
    }

    private static File unTar(File inputFile, File outputDirectory) throws FileNotFoundException, IOException, ArchiveException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("  Extract Tar file {} to dir {}.", (Object)inputFile.getAbsolutePath(), (Object)outputDirectory.getAbsolutePath());
        }
        File tarDir = ArtifactArchiveUtil.extractArchiveFile(inputFile, outputDirectory, TAR_ARCHIVE_TYPE);
        return tarDir;
    }

    private static File createArchiveFile(File inputDir, File outputDirectory, String archiveType) throws ArchiveException, FileNotFoundException, IOException {
        String fileName = inputDir.getName() + "." + archiveType;
        outputDirectory.mkdirs();
        File answer = new File(outputDirectory, fileName);
        ArchiveStreamFactory os = new ArchiveStreamFactory();
        ArchiveOutputStream aos = os.createArchiveOutputStream(archiveType, new FileOutputStream(answer));
        List<File> fileList = ArtifactArchiveUtil.fileGlob(inputDir);
        for (File file : fileList) {
            if (file.isDirectory()) continue;
            ArchiveEntry archiveEntry = null;
            String entryName = ArtifactArchiveUtil.buildEntryName(inputDir, file);
            if (LOG.isDebugEnabled()) {
                LOG.debug("  Adding Entry : {} ", (Object)entryName);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("    Entry file location : {}", (Object)file.getAbsolutePath());
            }
            if (archiveType.equals(TAR_ARCHIVE_TYPE)) {
                archiveEntry = new TarArchiveEntry(file, entryName);
                if (file.getParentFile().getPath().endsWith("/bin")) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("    Setting executable tar entry mode to 750 {}", (Object)archiveEntry.getName());
                    }
                    ((TarArchiveEntry)archiveEntry).setMode(33256);
                } else {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("    Setting tar entry mode to 640 {}", (Object)archiveEntry.getName());
                    }
                    ((TarArchiveEntry)archiveEntry).setMode(33188);
                }
                ((TarArchiveOutputStream)aos).setLongFileMode(2);
            } else if (archiveType.equals(ZIP_ARCHIVE_TYPE)) {
                archiveEntry = new ZipArchiveEntry(file, entryName);
            }
            aos.putArchiveEntry(archiveEntry);
            FileInputStream fis = new FileInputStream(file);
            IOUtils.copy(fis, aos);
            fis.close();
            aos.closeArchiveEntry();
        }
        aos.flush();
        aos.finish();
        aos.close();
        return answer;
    }

    private static String buildEntryName(File archiveBaseDir, File entryFile) {
        String entryName = entryFile.getName();
        File parent = entryFile.getParentFile();
        while (!parent.getName().equals(archiveBaseDir.getName())) {
            entryName = parent.getName() + File.separator + entryName;
            parent = parent.getParentFile();
        }
        entryName = archiveBaseDir.getName() + File.separator + entryName;
        return entryName;
    }

    private static List<File> fileGlob(File parentDirectory) {
        ArrayList<File> fileList = new ArrayList<File>();
        if (parentDirectory.isDirectory()) {
            File[] children = parentDirectory.listFiles();
            for (int i = 0; i < children.length; ++i) {
                fileList.add(children[i]);
                if (!children[i].isDirectory()) continue;
                fileList.addAll(ArtifactArchiveUtil.fileGlob(children[i]));
            }
        }
        return fileList;
    }

    private static File extractArchiveFile(File archiveFile, File outputDirectory, String archiveType) throws ArchiveException, FileNotFoundException, IOException {
        ArchiveInputStream ais = new ArchiveStreamFactory().createArchiveInputStream(archiveType, new FileInputStream(archiveFile));
        ArchiveEntry entry = null;
        while ((entry = ais.getNextEntry()) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  Extracting Entry : {} ", (Object)entry.getName());
            }
            File outputFile = new File(outputDirectory, entry.getName());
            if (entry.isDirectory()) {
                if (outputFile.exists()) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("    Creating directory {}", (Object)outputFile.getAbsolutePath());
                }
                if (outputFile.mkdirs()) continue;
                throw new IllegalStateException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("    Creating file {}.", (Object)outputFile.getAbsolutePath());
            }
            if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                throw new IllegalStateException(String.format("Couldn't create directory %s.", outputFile.getAbsolutePath()));
            }
            FileOutputStream outputFileStream = new FileOutputStream(outputFile);
            IOUtils.copy(ais, outputFileStream);
            outputFileStream.flush();
            ((OutputStream)outputFileStream).close();
            if (!outputFile.getParentFile().getPath().endsWith("/bin")) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("    Set owner executable {}", (Object)outputFile.getName());
            }
            outputFile.setExecutable(true);
        }
        ais.close();
        if (LOG.isDebugEnabled()) {
            LOG.debug("  Deleting the local archive {} ", (Object)archiveFile.getName());
        }
        FileUtils.delete(archiveFile);
        Object[] extractedFiles = outputDirectory.listFiles();
        Object extractedArchive = null;
        extractedArchive = ObjectUtils.isArrayNotEmpty(extractedFiles) && extractedFiles.length == 1 && ((File)extractedFiles[0]).isDirectory() ? extractedFiles[0] : outputDirectory;
        return extractedArchive;
    }
}

