/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.tooling.fuse.cdc.api.resolver;

import com.fusesource.tooling.fuse.cdc.api.Configuration;
import com.fusesource.tooling.fuse.cdc.api.resolver.RepositoryConfiguration;
import com.fusesource.tooling.fuse.cdc.api.resolver.ResolverUtils;
import com.fusesource.tooling.fuse.cdc.api.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.filter.DependencyFilterUtils;

public class Resolver {
    private static final Logger LOG = LoggerFactory.getLogger(Resolver.class);
    private Configuration configuration;

    public Resolver(Configuration configuration) {
        this.configuration = configuration;
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration must not be null");
        }
    }

    public List<ArtifactResult> resolveArtifact(Artifact artifact) {
        return this.resolveArtifact(artifact, null, false);
    }

    public List<ArtifactResult> resolveArtifact(Artifact artifact, boolean transitive) {
        return this.resolveArtifact(artifact, null, transitive);
    }

    public List<ArtifactResult> resolveArtifact(Artifact artifact, String dedicatedRepository) {
        return this.resolveArtifact(artifact, dedicatedRepository, false);
    }

    public List<ArtifactResult> resolveArtifact(Artifact artifact, String dedicatedRepository, boolean transitive) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fetching Artifact:");
            LOG.debug("  Artifact Details:");
            LOG.debug("  Group ID        : {}", (Object)artifact.getGroupId());
            LOG.debug("  Artifcat ID     : {}", (Object)artifact.getArtifactId());
            LOG.debug("  Version         : {}", (Object)artifact.getVersion());
        }
        if (!artifact.getExtension().equals("pom")) {
            DefaultArtifact pom = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "pom", artifact.getVersion());
            this.fetchArtifact(pom, dedicatedRepository, transitive);
        }
        return this.fetchArtifact(artifact, dedicatedRepository, transitive);
    }

    private List<ArtifactResult> fetchArtifact(Artifact artifact, String dedicatedRepository, boolean transitive) {
        LOG.debug("Fetching {}", (Object)artifact.getExtension().toUpperCase());
        ArrayList<ArtifactResult> artifactResults = new ArrayList<ArtifactResult>();
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(artifact);
        if (ObjectUtils.isStringNotEmpty(dedicatedRepository)) {
            LOG.warn("Remote Repository Override! Attempting to connect to {}", (Object)dedicatedRepository);
            ArrayList<RemoteRepository> dedicateRemoteRepositories = new ArrayList<RemoteRepository>();
            RepositoryConfiguration rc = new RepositoryConfiguration();
            rc.setId("dedicated.repo");
            rc.setLayout("default");
            rc.setUrl(dedicatedRepository);
            dedicateRemoteRepositories.add(ResolverUtils.createRepository(rc));
            artifactRequest.setRepositories(dedicateRemoteRepositories);
        } else {
            artifactRequest.setRepositories(this.getRemoteRepositories());
        }
        ArtifactResult artifactResult = null;
        try {
            List<ArtifactResult> transitiveResults;
            artifactResult = this.getRepositorySystem().resolveArtifact(this.getRepositorySystemSession(), artifactRequest);
            artifactResults.add(artifactResult);
            artifact = artifactResult.getArtifact();
            if (LOG.isDebugEnabled()) {
                LOG.debug("  Artifact location: {}", artifact.getFile());
            }
            if (transitive && (transitiveResults = this.resolveTransitiveDependencies(artifact)) != null) {
                for (ArtifactResult result : transitiveResults) {
                    if (this.artifactsAreEqual(artifact, result.getArtifact())) continue;
                    artifactResults.add(result);
                }
            }
        }
        catch (ArtifactResolutionException e) {
            LOG.error("ArtifactResolutionException: " + e.getLocalizedMessage());
        }
        catch (DependencyCollectionException e) {
            LOG.error("DependencyResolutionException: " + e.getLocalizedMessage());
        }
        return artifactResults;
    }

    private List<ArtifactResult> resolveTransitiveDependencies(Artifact artifact) throws DependencyCollectionException, ArtifactResolutionException {
        LOG.debug("Fetching Transitive Dependencies:");
        DependencyFilter classpathFlter = DependencyFilterUtils.classpathFilter("compile");
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(artifact, "compile"));
        collectRequest.setRepositories(this.getRemoteRepositories());
        List<ArtifactResult> artifactResults = this.getRepositorySystem().resolveDependencies(this.getRepositorySystemSession(), collectRequest, classpathFlter);
        if (LOG.isDebugEnabled()) {
            for (ArtifactResult artifactResult : artifactResults) {
                LOG.debug(artifactResult.getArtifact() + " resolved to " + artifactResult.getArtifact().getFile());
            }
        }
        return artifactResults;
    }

    private RepositorySystem getRepositorySystem() {
        return this.configuration.getRepositorySystem();
    }

    private RepositorySystemSession getRepositorySystemSession() {
        return this.configuration.getRepositorySystemSession();
    }

    private List<RemoteRepository> getRemoteRepositories() {
        return this.configuration.getRemoteRepositories();
    }

    private boolean artifactsAreEqual(Artifact arg1, Artifact arg2) {
        if (arg1 == null) {
            return false;
        }
        if (arg2 == null) {
            return false;
        }
        return arg1.getGroupId().equals(arg2.getGroupId()) && arg1.getArtifactId().equals(arg2.getArtifactId()) && arg1.getVersion().equals(arg2.getVersion()) && arg1.getExtension().equals(arg2.getExtension()) && arg1.getClassifier().equals(arg2.getClassifier());
    }
}

