/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.tooling.fuse.cdc.api.resolver;

import com.fusesource.tooling.fuse.cdc.api.resolver.RepositoryConfiguration;
import com.fusesource.tooling.fuse.cdc.api.utils.ObjectUtils;
import java.net.URI;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;

public class ResolverUtils {
    public static String toArtifactCoords(String groupId, String artifactId, String version) {
        return groupId + ":" + artifactId + ":" + version;
    }

    public static String toArtifactCoords(String groupId, String artifactId, String version, String type) {
        return groupId + ":" + artifactId + ":" + type + ":" + version;
    }

    public static String toArtifactCoords(String groupId, String artifactId, String version, String type, String classifier) {
        return groupId + ":" + artifactId + ":" + type + ":" + classifier + ":" + version;
    }

    public static String toArtifactCoords(URI featureUri) {
        return ResolverUtils.toArtifactCoords(featureUri.toString());
    }

    public static String toArtifactCoords(String featureUri) {
        String answer = null;
        String cleanedURI = null;
        cleanedURI = featureUri.contains(":") ? featureUri.substring(featureUri.indexOf(58) + 1) : featureUri;
        String[] coords = cleanedURI.split("/");
        if (coords.length == 3) {
            answer = ResolverUtils.toArtifactCoords(coords[0], coords[1], coords[2]);
        } else if (coords.length == 4) {
            answer = ResolverUtils.toArtifactCoords(coords[0], coords[1], coords[2], coords[3]);
        } else if (coords.length == 5) {
            answer = ResolverUtils.toArtifactCoords(coords[0], coords[1], coords[2], coords[3], coords[4]);
        }
        return answer;
    }

    public static RemoteRepository createRepository(RepositoryConfiguration repositoryConfiguration) {
        RepositoryPolicy sp;
        RepositoryPolicy rp;
        RemoteRepository repo = new RemoteRepository(repositoryConfiguration.getId(), repositoryConfiguration.getLayout(), repositoryConfiguration.getUrl());
        if (ObjectUtils.isStringNotEmpty(repositoryConfiguration.getUsername()) && ObjectUtils.isStringNotEmpty(repositoryConfiguration.getPassword())) {
            repo.setAuthentication(new Authentication(repositoryConfiguration.getUsername(), repositoryConfiguration.getPassword()));
        }
        URI proxyUri = repositoryConfiguration.getProxyUri();
        Proxy proxy = null;
        if (proxyUri != null) {
            String userInfo = proxyUri.getRawUserInfo();
            Authentication auth = null;
            if (ObjectUtils.isStringNotEmpty(userInfo)) {
                String[] pair = userInfo.split(":");
                auth = new Authentication(pair[0], pair[1]);
            }
            proxy = new Proxy(proxyUri.getSchemeSpecificPart(), proxyUri.getHost(), proxyUri.getPort(), auth);
            repo.setProxy(proxy);
        }
        if (repositoryConfiguration.isReleaseEnabled()) {
            rp = new RepositoryPolicy();
            rp.setEnabled(true);
            rp.setChecksumPolicy(repositoryConfiguration.getReleaseChecksumPolicy());
            rp.setUpdatePolicy(repositoryConfiguration.getReleaseUpdatePolicy());
            repo.setPolicy(false, rp);
        } else {
            rp = new RepositoryPolicy();
            rp.setEnabled(false);
            repo.setPolicy(false, rp);
        }
        if (repositoryConfiguration.isSnapshotEnabled()) {
            sp = new RepositoryPolicy();
            sp.setEnabled(true);
            sp.setChecksumPolicy(repositoryConfiguration.getSnapshotChecksumPolicy());
            sp.setUpdatePolicy(repositoryConfiguration.getSnapshotUpdatePolicy());
            repo.setPolicy(true, sp);
        } else {
            sp = new RepositoryPolicy();
            sp.setEnabled(false);
            repo.setPolicy(true, sp);
        }
        return repo;
    }
}

