/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.tooling.fuse.cdc.api.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FileUtils.class);

    public static void delete(File file) throws IOException {
        if (file.getCanonicalFile().isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
                LOG.debug("Directory is deleted : " + file.getAbsolutePath());
            } else {
                String[] files;
                for (String temp : files = file.list()) {
                    File fileDelete = new File(file, temp);
                    FileUtils.delete(fileDelete);
                }
                if (file.list().length == 0) {
                    file.delete();
                    LOG.debug("Directory is deleted : " + file.getAbsolutePath());
                }
            }
        } else {
            try {
                file.setWritable(true);
                boolean deleted = file.delete();
                if (deleted) {
                    LOG.debug("File is deleted : " + file.getAbsolutePath());
                } else {
                    LOG.warn("Failed to delete file : " + file.getAbsolutePath());
                }
            }
            catch (Exception e) {
                LOG.error("Failed to delete file : " + file.getAbsolutePath(), e);
            }
        }
    }

    public static void move(File original, File destination) throws FileNotFoundException, IOException {
        FileInputStream cfgFis = new FileInputStream(original);
        FileOutputStream cfgFos = new FileOutputStream(destination);
        IOUtils.copy(cfgFis, cfgFos);
        cfgFis.close();
        cfgFos.flush();
        cfgFos.close();
    }
}

