/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.connector.file;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ParallelRepositoryConnector {
    private static final String TG_NAME = "FileRepositoryConnector";
    private static final String T_NAME = "FileRepositoryConnectorThread";
    private static final int MAX_POOL_SIZE = 5;
    private static final int INITIAL_POOL_SIZE = 2;
    private static final long KEEPALIVE = 60L;
    private Map<String, Object> config = Collections.emptyMap();
    private boolean closed = false;
    protected static ThreadPoolExecutor executor;

    public ParallelRepositoryConnector(Map<String, Object> config) {
        this.config = config;
        this.initExecutor();
    }

    protected void initExecutor() {
        this.initExecutor(false);
    }

    protected void initExecutor(boolean forceInit) {
        if (executor == null || forceInit) {
            Object tgName = this.config.get("aether.connector.file.threads.groupname");
            Object tName = this.config.get("aether.connector.file.threads.name");
            Object maximumPoolSize = this.config.get("aether.connector.file.threads.max");
            Object initialPoolSize = this.config.get("aether.connector.file.threads.initial");
            Object keepAlive = this.config.get("aether.connector.file.threads.keepalive");
            tgName = tgName != null ? tgName : TG_NAME;
            tName = tName != null ? tName : T_NAME;
            int mPS = maximumPoolSize != null ? Integer.valueOf(maximumPoolSize.toString()) : 5;
            int iPS = initialPoolSize != null ? Integer.valueOf(initialPoolSize.toString()) : 2;
            long kAlive = keepAlive != null ? Long.valueOf(keepAlive.toString()) : 60L;
            RepositoryConnectorThreadFactory threadFactory = new RepositoryConnectorThreadFactory(tgName.toString(), tName.toString());
            LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
            TimeUnit timeUnit = TimeUnit.SECONDS;
            executor = new ThreadPoolExecutor(iPS, mPS, kAlive, timeUnit, workQueue, threadFactory);
        }
    }

    public void close() {
        this.closed = true;
    }

    protected void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Connector is closed");
        }
    }

    protected static class RepositoryConnectorThreadFactory
    implements ThreadFactory {
        private final ThreadGroup myTG;
        private final AtomicInteger counter = new AtomicInteger(1);
        private String tName;

        public RepositoryConnectorThreadFactory(String tgName, String tName) {
            this.myTG = new ThreadGroup(Thread.currentThread().getThreadGroup().getParent(), tgName);
            this.tName = tName;
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.myTG, r, this.tName + "-" + this.counter.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

