/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.connector.file;

import java.io.File;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.connector.file.DefaultLayout;
import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.spi.connector.ArtifactDownload;
import org.sonatype.aether.spi.connector.ArtifactTransfer;
import org.sonatype.aether.spi.connector.MetadataDownload;
import org.sonatype.aether.spi.connector.MetadataTransfer;
import org.sonatype.aether.spi.connector.Transfer;
import org.sonatype.aether.transfer.ArtifactTransferException;
import org.sonatype.aether.transfer.MetadataTransferException;

class TransferWrapper {
    private Type type;
    private MetadataTransfer metadataTransfer;
    private ArtifactTransfer artifactTransfer;
    private Transfer transfer;
    private String checksumPolicy = null;
    private boolean existenceCheck = false;

    public Type getType() {
        return this.type;
    }

    public TransferWrapper(ArtifactTransfer transfer) {
        this.artifactTransfer = transfer;
        this.transfer = transfer;
        this.type = Type.ARTIFACT;
        if (transfer instanceof ArtifactDownload) {
            this.checksumPolicy = ((ArtifactDownload)transfer).getChecksumPolicy();
            this.existenceCheck = ((ArtifactDownload)transfer).isExistenceCheck();
        }
    }

    public TransferWrapper(MetadataTransfer transfer) {
        this.metadataTransfer = transfer;
        this.transfer = transfer;
        this.type = Type.METADATA;
        if (transfer instanceof MetadataDownload) {
            this.checksumPolicy = ((MetadataDownload)transfer).getChecksumPolicy();
        }
    }

    public void setState(Transfer.State new1) {
        this.transfer.setState(new1);
    }

    public File getFile() {
        File ret = null;
        if (this.metadataTransfer != null) {
            ret = this.metadataTransfer.getFile();
        } else if (this.artifactTransfer != null) {
            ret = this.artifactTransfer.getFile();
        }
        if (ret == null) {
            if (this.metadataTransfer != null) {
                ret = this.metadataTransfer.getMetadata().getFile();
            } else if (this.artifactTransfer != null) {
                ret = this.artifactTransfer.getArtifact().getFile();
            }
        }
        return ret;
    }

    public Artifact getArtifact() {
        if (this.artifactTransfer != null) {
            return this.artifactTransfer.getArtifact();
        }
        throw new IllegalStateException("TransferWrapper holds the wrong type");
    }

    public void setException(ArtifactTransferException exception) {
        if (this.artifactTransfer == null) {
            throw new IllegalStateException("TransferWrapper holds the wrong type");
        }
        this.artifactTransfer.setException(exception);
    }

    public void setException(MetadataTransferException exception) {
        if (this.metadataTransfer == null) {
            throw new IllegalStateException("TransferWrapper holds the wrong type");
        }
        this.metadataTransfer.setException(exception);
    }

    public Exception getException() {
        if (this.artifactTransfer != null) {
            return this.artifactTransfer.getException();
        }
        if (this.metadataTransfer != null) {
            return this.metadataTransfer.getException();
        }
        throw new IllegalStateException("TransferWrapper holds the wrong type");
    }

    public Metadata getMetadata() {
        return this.metadataTransfer.getMetadata();
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    public boolean isExistenceCheck() {
        return this.existenceCheck;
    }

    public String getRelativePath() {
        if (this.artifactTransfer != null) {
            return new DefaultLayout().getPath(this.getArtifact());
        }
        if (this.metadataTransfer != null) {
            return new DefaultLayout().getPath(this.getMetadata());
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ARTIFACT,
        METADATA;

    }
}

