/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.impl.Installer;
import org.sonatype.aether.impl.LocalRepositoryEvent;
import org.sonatype.aether.impl.LocalRepositoryMaintainer;
import org.sonatype.aether.impl.MetadataGenerator;
import org.sonatype.aether.impl.MetadataGeneratorFactory;
import org.sonatype.aether.impl.RepositoryEventDispatcher;
import org.sonatype.aether.impl.internal.DefaultLocalRepositoryEvent;
import org.sonatype.aether.installation.InstallRequest;
import org.sonatype.aether.installation.InstallResult;
import org.sonatype.aether.installation.InstallationException;
import org.sonatype.aether.metadata.MergeableMetadata;
import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.repository.LocalArtifactRegistration;
import org.sonatype.aether.repository.LocalMetadataRegistration;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.spi.io.FileProcessor;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;
import org.sonatype.aether.util.listener.DefaultRepositoryEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=Installer.class)
public class DefaultInstaller
implements Installer,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement
    private FileProcessor fileProcessor;
    @Requirement
    private RepositoryEventDispatcher repositoryEventDispatcher;
    @Requirement(role=LocalRepositoryMaintainer.class)
    private List<LocalRepositoryMaintainer> localRepositoryMaintainers = new ArrayList<LocalRepositoryMaintainer>();
    @Requirement(role=MetadataGeneratorFactory.class)
    private List<MetadataGeneratorFactory> metadataFactories = new ArrayList<MetadataGeneratorFactory>();
    private static final Comparator<MetadataGeneratorFactory> COMPARATOR = new Comparator<MetadataGeneratorFactory>(){

        @Override
        public int compare(MetadataGeneratorFactory o1, MetadataGeneratorFactory o2) {
            return o2.getPriority() - o1.getPriority();
        }
    };

    public DefaultInstaller() {
    }

    public DefaultInstaller(Logger logger, FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, List<MetadataGeneratorFactory> metadataFactories, List<LocalRepositoryMaintainer> localRepositoryMaintainers) {
        this.setLogger(logger);
        this.setFileProcessor(fileProcessor);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setMetadataFactories(metadataFactories);
        this.setLocalRepositoryMaintainers(localRepositoryMaintainers);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLogger(locator.getService(Logger.class));
        this.setFileProcessor(locator.getService(FileProcessor.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setLocalRepositoryMaintainers(locator.getServices(LocalRepositoryMaintainer.class));
        this.setMetadataFactories(locator.getServices(MetadataGeneratorFactory.class));
    }

    public DefaultInstaller setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public DefaultInstaller setFileProcessor(FileProcessor fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("file processor has not been specified");
        }
        this.fileProcessor = fileProcessor;
        return this;
    }

    public DefaultInstaller setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        if (repositoryEventDispatcher == null) {
            throw new IllegalArgumentException("repository event dispatcher has not been specified");
        }
        this.repositoryEventDispatcher = repositoryEventDispatcher;
        return this;
    }

    public DefaultInstaller addLocalRepositoryMaintainer(LocalRepositoryMaintainer maintainer) {
        if (maintainer == null) {
            throw new IllegalArgumentException("local repository maintainer has not been specified");
        }
        this.localRepositoryMaintainers.add(maintainer);
        return this;
    }

    public DefaultInstaller setLocalRepositoryMaintainers(List<LocalRepositoryMaintainer> maintainers) {
        this.localRepositoryMaintainers = maintainers == null ? new ArrayList<LocalRepositoryMaintainer>() : maintainers;
        return this;
    }

    public DefaultInstaller addMetadataGeneratorFactory(MetadataGeneratorFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("metadata generator factory has not been specified");
        }
        this.metadataFactories.add(factory);
        return this;
    }

    public DefaultInstaller setMetadataFactories(List<MetadataGeneratorFactory> metadataFactories) {
        this.metadataFactories = metadataFactories == null ? new ArrayList<MetadataGeneratorFactory>() : metadataFactories;
        return this;
    }

    @Override
    public InstallResult install(RepositorySystemSession session, InstallRequest request) throws InstallationException {
        InstallResult result = new InstallResult(request);
        List<MetadataGenerator> generators = this.getMetadataGenerators(session, request);
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(request.getArtifacts());
        IdentityHashMap processedMetadata = new IdentityHashMap();
        for (MetadataGenerator generator : generators) {
            for (Metadata metadata : generator.prepare(artifacts)) {
                this.install(session, metadata);
                processedMetadata.put(metadata, null);
                result.addMetadata(metadata);
            }
        }
        for (int i = 0; i < artifacts.size(); ++i) {
            Artifact artifact = (Artifact)artifacts.get(i);
            for (MetadataGenerator metadataGenerator : generators) {
                artifact = metadataGenerator.transformArtifact(artifact);
            }
            artifacts.set(i, artifact);
            this.install(session, artifact);
            result.addArtifact(artifact);
        }
        for (MetadataGenerator generator : generators) {
            for (Metadata metadata : generator.finish(artifacts)) {
                this.install(session, metadata);
                processedMetadata.put(metadata, null);
                result.addMetadata(metadata);
            }
        }
        for (Metadata metadata : request.getMetadata()) {
            if (processedMetadata.containsKey(metadata)) continue;
            this.install(session, metadata);
            result.addMetadata(metadata);
        }
        return result;
    }

    private List<MetadataGenerator> getMetadataGenerators(RepositorySystemSession session, InstallRequest request) {
        ArrayList<MetadataGeneratorFactory> factories = new ArrayList<MetadataGeneratorFactory>(this.metadataFactories);
        Collections.sort(factories, COMPARATOR);
        ArrayList<MetadataGenerator> generators = new ArrayList<MetadataGenerator>();
        for (MetadataGeneratorFactory factory : factories) {
            MetadataGenerator generator = factory.newInstance(session, request);
            if (generator == null) continue;
            generators.add(generator);
        }
        return generators;
    }

    private void install(RepositorySystemSession session, Artifact artifact) throws InstallationException {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        File srcFile = artifact.getFile();
        File dstFile = new File(lrm.getRepository().getBasedir(), lrm.getPathForLocalArtifact(artifact));
        this.artifactInstalling(session, artifact, dstFile);
        Exception exception = null;
        try {
            boolean copy;
            boolean bl = copy = "pom".equals(artifact.getExtension()) || srcFile.lastModified() != dstFile.lastModified() || srcFile.length() != dstFile.length();
            if (copy) {
                this.fileProcessor.copy(srcFile, dstFile, null);
                dstFile.setLastModified(srcFile.lastModified());
            } else {
                this.logger.debug("Skipped re-installing " + srcFile + " to " + dstFile + ", seems unchanged");
            }
            lrm.add(session, new LocalArtifactRegistration(artifact));
            if (!this.localRepositoryMaintainers.isEmpty()) {
                DefaultLocalRepositoryEvent event = new DefaultLocalRepositoryEvent(LocalRepositoryEvent.EventType.ARTIFACT_INSTALLED, session, artifact, dstFile);
                for (LocalRepositoryMaintainer maintainer : this.localRepositoryMaintainers) {
                    maintainer.artifactInstalled(event);
                }
            }
        }
        catch (Exception e) {
            exception = e;
            throw new InstallationException("Failed to install artifact " + artifact + ": " + e.getMessage(), e);
        }
        finally {
            this.artifactInstalled(session, artifact, dstFile, exception);
        }
    }

    private void install(RepositorySystemSession session, Metadata metadata) throws InstallationException {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        File dstFile = new File(lrm.getRepository().getBasedir(), lrm.getPathForLocalMetadata(metadata));
        this.metadataInstalling(session, metadata, dstFile);
        Exception exception = null;
        try {
            if (metadata instanceof MergeableMetadata) {
                ((MergeableMetadata)metadata).merge(dstFile, dstFile);
            } else {
                this.fileProcessor.copy(metadata.getFile(), dstFile, null);
            }
            session.getLocalRepositoryManager().add(session, new LocalMetadataRegistration(metadata));
        }
        catch (Exception e) {
            exception = e;
            throw new InstallationException("Failed to install metadata " + metadata + ": " + e.getMessage(), e);
        }
        finally {
            this.metadataInstalled(session, metadata, dstFile, exception);
        }
    }

    private void artifactInstalling(RepositorySystemSession session, Artifact artifact, File dstFile) {
        DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.ARTIFACT_INSTALLING, session);
        event.setArtifact(artifact);
        event.setRepository(session.getLocalRepositoryManager().getRepository());
        event.setFile(dstFile);
        this.repositoryEventDispatcher.dispatch(event);
    }

    private void artifactInstalled(RepositorySystemSession session, Artifact artifact, File dstFile, Exception exception) {
        DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.ARTIFACT_INSTALLED, session);
        event.setArtifact(artifact);
        event.setRepository(session.getLocalRepositoryManager().getRepository());
        event.setFile(dstFile);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event);
    }

    private void metadataInstalling(RepositorySystemSession session, Metadata metadata, File dstFile) {
        DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.METADATA_INSTALLING, session);
        event.setMetadata(metadata);
        event.setRepository(session.getLocalRepositoryManager().getRepository());
        event.setFile(dstFile);
        this.repositoryEventDispatcher.dispatch(event);
    }

    private void metadataInstalled(RepositorySystemSession session, Metadata metadata, File dstFile, Exception exception) {
        DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.METADATA_INSTALLED, session);
        event.setMetadata(metadata);
        event.setRepository(session.getLocalRepositoryManager().getRepository());
        event.setFile(dstFile);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event);
    }
}

