/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Map;
import java.util.Properties;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TrackingFileManager {
    private Logger logger = NullLogger.INSTANCE;

    TrackingFileManager() {
    }

    public TrackingFileManager setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Properties read(File file) {
        Object object = this.getLock(file);
        synchronized (object) {
            block8: {
                Properties properties;
                FileLock lock = null;
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(file);
                    lock = stream.getChannel().lock(0L, Math.max(1L, file.length()), true);
                    Properties props = new Properties();
                    props.load(stream);
                    properties = props;
                    this.release(lock, file);
                    this.close(stream, file);
                }
                catch (FileNotFoundException e) {
                    this.release(lock, file);
                    this.close(stream, file);
                    break block8;
                    catch (IOException e2) {
                        try {
                            this.logger.debug("Failed to read resolution tracking file " + file, e2);
                            this.release(lock, file);
                            this.close(stream, file);
                            break block8;
                        }
                        catch (Throwable throwable) {
                            this.release(lock, file);
                            this.close(stream, file);
                            throw throwable;
                        }
                    }
                }
                return properties;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties update(File file, Map<String, String> updates) {
        Properties props = new Properties();
        Object object = this.getLock(file);
        synchronized (object) {
            File directory = file.getParentFile();
            if (!directory.exists() && !directory.mkdirs()) {
                this.logger.debug("Failed to create parent directories for resolution tracking file " + file);
                return props;
            }
            RandomAccessFile raf = null;
            FileLock lock = null;
            try {
                raf = new RandomAccessFile(file, "rw");
                lock = raf.getChannel().lock(0L, Math.max(1L, raf.length()), false);
                if (file.canRead()) {
                    this.logger.debug("Reading resolution tracking file " + file);
                    byte[] buffer = new byte[(int)raf.length()];
                    raf.readFully(buffer);
                    ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                    props.load(stream);
                }
                for (Map.Entry<String, String> update : updates.entrySet()) {
                    if (update.getValue() == null) {
                        props.remove(update.getKey());
                        continue;
                    }
                    props.setProperty(update.getKey(), update.getValue());
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream(2048);
                this.logger.debug("Writing resolution tracking file " + file);
                props.store(stream, "NOTE: This is an internal implementation file, its format can be changed without prior notice.");
                raf.seek(0L);
                raf.write(stream.toByteArray());
                raf.setLength(raf.getFilePointer());
                this.release(lock, file);
                this.close(raf, file);
            }
            catch (IOException e) {
                try {
                    this.logger.debug("Failed to write resolution tracking file " + file, e);
                    this.release(lock, file);
                    this.close(raf, file);
                }
                catch (Throwable throwable) {
                    this.release(lock, file);
                    this.close(raf, file);
                    throw throwable;
                }
            }
        }
        return props;
    }

    private void release(FileLock lock, File file) {
        if (lock != null) {
            try {
                lock.release();
            }
            catch (IOException e) {
                this.logger.debug("Error releasing lock for resolution tracking file " + file, e);
            }
        }
    }

    private void close(Closeable closeable, File file) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                this.logger.debug("Error closing resolution tracking file " + file, e);
            }
        }
    }

    private Object getLock(File file) {
        return file.getAbsolutePath().intern();
    }
}

