/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.io;

import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.io.BytesInputStream;
import com.ghgande.j2mod.modbus.io.BytesOutputStream;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.msg.ModbusMessage;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.msg.ModbusResponse;
import com.ghgande.j2mod.modbus.net.AbstractModbusListener;
import com.ghgande.j2mod.modbus.util.ModbusUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusASCIITransport
extends ModbusSerialTransport {
    private static final Logger logger = LoggerFactory.getLogger(ModbusASCIITransport.class);
    private final byte[] inBuffer = new byte[256];
    private final BytesInputStream byteInputStream = new BytesInputStream(this.inBuffer);
    private final BytesOutputStream byteInputOutputStream = new BytesOutputStream(this.inBuffer);
    private final BytesOutputStream byteOutputStream = new BytesOutputStream(256);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeMessageOut(ModbusMessage msg) throws ModbusIOException {
        try {
            BytesOutputStream bytesOutputStream = this.byteOutputStream;
            synchronized (bytesOutputStream) {
                msg.setHeadless();
                msg.writeTo(this.byteOutputStream);
                byte[] buf = this.byteOutputStream.getBuffer();
                int len = this.byteOutputStream.size();
                this.writeAsciiByte(1000);
                this.writeAsciiBytes(buf, len);
                if (logger.isDebugEnabled()) {
                    logger.debug("Writing: {}", (Object)ModbusUtil.toHex(buf, 0, len));
                }
                this.writeAsciiByte(ModbusASCIITransport.calculateLRC(buf, 0, len));
                this.writeAsciiByte(2000);
                this.byteOutputStream.reset();
                if (this.echo) {
                    this.readEcho(len + 3);
                }
            }
        }
        catch (IOException ex) {
            throw new ModbusIOException("I/O failed to write");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public ModbusRequest readRequestIn(AbstractModbusListener listener) throws ModbusIOException {
        boolean done = false;
        ModbusRequest request = null;
        try {
            while (true) {
                int in;
                if (this.readAsciiByte() != 1000) {
                    continue;
                }
                byte[] byArray = this.inBuffer;
                // MONITORENTER : this.inBuffer
                this.byteInputOutputStream.reset();
                while ((in = this.readAsciiByte()) != 2000) {
                    if (in == -1) {
                        throw new IOException("I/O exception - Serial port timeout");
                    }
                    this.byteInputOutputStream.writeByte(in);
                }
                if (this.inBuffer[this.byteInputOutputStream.size() - 1] != ModbusASCIITransport.calculateLRC(this.inBuffer, 0, this.byteInputOutputStream.size(), 1)) {
                    // MONITOREXIT : byArray
                } else {
                    this.byteInputStream.reset(this.inBuffer, this.byteInputOutputStream.size());
                    int unitID = this.byteInputStream.readUnsignedByte();
                    int functionCode = this.byteInputStream.readUnsignedByte();
                    request = ModbusRequest.createModbusRequest(functionCode);
                    request.setHeadless();
                    this.byteInputStream.reset(this.inBuffer, this.byteInputOutputStream.size());
                    request.readFrom(this.byteInputStream);
                    // MONITOREXIT : byArray
                    done = true;
                }
                if (done) return request;
            }
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage());
            throw new ModbusIOException("I/O exception - failed to read");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected ModbusResponse readResponseIn() throws ModbusIOException {
        boolean done = false;
        ModbusResponse response = null;
        try {
            while (true) {
                int in;
                if ((in = this.readAsciiByte()) != 1000) {
                    if (in != -1) continue;
                    throw new IOException("I/O exception - Serial port timeout");
                }
                byte[] byArray = this.inBuffer;
                // MONITORENTER : this.inBuffer
                this.byteInputOutputStream.reset();
                while ((in = this.readAsciiByte()) != 2000) {
                    if (in == -1) {
                        throw new IOException("I/O exception - Serial port timeout");
                    }
                    this.byteInputOutputStream.writeByte(in);
                }
                int len = this.byteInputOutputStream.size();
                if (logger.isDebugEnabled()) {
                    logger.debug("Received: {}", (Object)ModbusUtil.toHex(this.inBuffer, 0, len));
                }
                if (this.inBuffer[len - 1] != ModbusASCIITransport.calculateLRC(this.inBuffer, 0, len, 1)) {
                    // MONITOREXIT : byArray
                } else {
                    this.byteInputStream.reset(this.inBuffer, this.byteInputOutputStream.size());
                    this.byteInputStream.readUnsignedByte();
                    in = this.byteInputStream.readUnsignedByte();
                    response = ModbusResponse.createModbusResponse(in);
                    response.setHeadless();
                    this.byteInputStream.reset(this.inBuffer, this.byteInputOutputStream.size());
                    response.readFrom(this.byteInputStream);
                    // MONITOREXIT : byArray
                    done = true;
                }
                if (done) return response;
            }
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage());
            throw new ModbusIOException("I/O exception - failed to read");
        }
    }

    private static int calculateLRC(byte[] data, int off, int length) {
        return ModbusASCIITransport.calculateLRC(data, off, length, 0);
    }

    private static byte calculateLRC(byte[] data, int off, int length, int tailskip) {
        int lrc = 0;
        for (int i = off; i < length - tailskip; ++i) {
            lrc += data[i] & 0xFF;
        }
        return (byte)(-lrc & 0xFF);
    }
}

