/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.io;

import com.ghgande.j2mod.modbus.ModbusException;
import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.ModbusSlaveException;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.msg.ExceptionResponse;
import com.ghgande.j2mod.modbus.msg.ModbusRequest;
import com.ghgande.j2mod.modbus.net.TCPMasterConnection;
import com.ghgande.j2mod.modbus.util.ModbusUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTCPTransaction
extends ModbusTransaction {
    private static final Logger logger = LoggerFactory.getLogger(ModbusTCPTransaction.class);
    private TCPMasterConnection connection;
    protected boolean reconnecting = false;

    public ModbusTCPTransaction() {
    }

    public ModbusTCPTransaction(ModbusRequest request) {
        this.setRequest(request);
    }

    public ModbusTCPTransaction(TCPMasterConnection con) {
        this.setConnection(con);
        this.transport = con.getModbusTransport();
    }

    public void setConnection(TCPMasterConnection con) {
        this.connection = con;
        this.transport = con.getModbusTransport();
    }

    public boolean isReconnecting() {
        return this.reconnecting;
    }

    public void setReconnecting(boolean b) {
        this.reconnecting = b;
    }

    @Override
    public synchronized void execute() throws ModbusException {
        if (this.request == null || this.connection == null) {
            throw new ModbusException("Invalid request or connection");
        }
        int retryCounter = 0;
        int retryLimit = this.retries > 0 ? this.retries : 5;
        boolean keepTrying = true;
        while (keepTrying) {
            if (!this.connection.isConnected()) {
                try {
                    logger.debug("Connecting to: {}:{}", (Object)this.connection.getAddress().toString(), (Object)this.connection.getPort());
                    this.connection.connect();
                    this.transport = this.connection.getModbusTransport();
                }
                catch (Exception ex) {
                    throw new ModbusIOException("Connection failed for %s:%d", this.connection.getAddress().toString(), this.connection.getPort(), ex.getMessage());
                }
            }
            this.transport.setTimeout(this.connection.getTimeout());
            try {
                logger.debug("Writing request: {} (try: {}) request transaction ID = {} to {}:{}", new Object[]{this.request.getHexMessage(), retryCounter, this.request.getTransactionID(), this.connection.getAddress().toString(), this.connection.getPort()});
                this.transport.writeRequest(this.request);
                this.response = this.transport.readResponse();
                logger.debug("Read response: {} (try: {}) response transaction ID = {} from {}:{}", new Object[]{this.response.getHexMessage(), retryCounter, this.response.getTransactionID(), this.connection.getAddress().toString(), this.connection.getPort()});
                keepTrying = false;
                if (this.response instanceof ExceptionResponse) {
                    throw new ModbusSlaveException(((ExceptionResponse)this.response).getExceptionCode());
                }
                if (this.responseIsInValid()) {
                    if (++retryCounter >= retryLimit) {
                        throw new ModbusIOException("Executing transaction failed (tried %d times)", retryLimit);
                    }
                    keepTrying = true;
                    long sleepTime = this.getRandomSleepTime(retryCounter);
                    if (this.response == null) {
                        logger.debug("Failed to get any response (try: {}) - retrying after {} milliseconds", (Object)retryCounter, (Object)sleepTime);
                    } else {
                        logger.debug("Failed to get a valid response, transaction IDs do not match (try: {}) - retrying after {} milliseconds", (Object)retryCounter, (Object)sleepTime);
                    }
                    ModbusUtil.sleep(sleepTime);
                }
            }
            catch (ModbusIOException ex) {
                if (++retryCounter >= retryLimit) {
                    throw new ModbusIOException("Executing transaction %s failed (tried %d times) %s", this.request.getHexMessage(), retryLimit, ex.getMessage());
                }
                long sleepTime = this.getRandomSleepTime(retryCounter);
                logger.debug("Failed transaction Request: {} (try: {}) - retrying after {} milliseconds", new Object[]{this.request.getHexMessage(), retryCounter, sleepTime});
                ModbusUtil.sleep(sleepTime);
                logger.debug("Failed request {} (try: {}) request transaction ID = {} - {} closing and re-opening connection {}:{}", new Object[]{this.request.getHexMessage(), retryCounter, this.request.getTransactionID(), ex.getMessage(), this.connection.getAddress().toString(), this.connection.getPort()});
                this.connection.close();
            }
            if (!keepTrying) continue;
            this.incrementTransactionID();
        }
        if (this.isReconnecting()) {
            this.connection.close();
        }
        this.incrementTransactionID();
    }

    private boolean responseIsInValid() {
        if (this.response == null) {
            return true;
        }
        if (!this.response.isHeadless() && this.validityCheck) {
            return this.request.getTransactionID() != this.response.getTransactionID();
        }
        return false;
    }

    private synchronized void incrementTransactionID() {
        if (this.isCheckingValidity()) {
            transactionID = transactionID >= Short.MAX_VALUE ? 0 : ++transactionID;
        }
        this.request.setTransactionID(this.getTransactionID());
    }
}

