/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.net;

import com.ghgande.j2mod.modbus.ModbusIOException;
import com.ghgande.j2mod.modbus.io.AbstractModbusTransport;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.net.AbstractModbusListener;
import com.ghgande.j2mod.modbus.net.AbstractSerialConnection;
import com.ghgande.j2mod.modbus.net.SerialConnection;
import com.ghgande.j2mod.modbus.util.SerialParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusSerialListener
extends AbstractModbusListener {
    private static final Logger logger = LoggerFactory.getLogger(ModbusSerialListener.class);
    private AbstractSerialConnection serialCon;

    public ModbusSerialListener(SerialParameters params) {
        this.serialCon = new SerialConnection(params);
    }

    public ModbusSerialListener(AbstractSerialConnection serialCon) {
        this.serialCon = serialCon;
    }

    @Override
    public void setTimeout(int timeout) {
        ModbusSerialTransport transport;
        super.setTimeout(timeout);
        if (this.serialCon != null && this.listening && (transport = (ModbusSerialTransport)this.serialCon.getModbusTransport()) != null) {
            transport.setTimeout(timeout);
        }
    }

    @Override
    public void run() {
        if (this.threadName == null || this.threadName.isEmpty()) {
            this.threadName = String.format("Modbus Serial Listener [port:%s]", this.serialCon.getDescriptivePortName());
        }
        Thread.currentThread().setName(this.threadName);
        try {
            this.serialCon.open();
        }
        catch (Exception e) {
            this.error = String.format("Cannot start Serial listener - %s", e.getMessage());
            this.listening = false;
            return;
        }
        this.listening = true;
        try {
            AbstractModbusTransport transport = this.serialCon.getModbusTransport();
            while (this.listening) {
                try {
                    this.handleRequest(transport, this);
                }
                catch (ModbusIOException ex) {
                    logger.debug(ex.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception occurred while handling request.", (Throwable)e);
        }
        finally {
            this.listening = false;
            this.serialCon.close();
        }
    }

    @Override
    public void stop() {
        if (this.serialCon != null) {
            this.serialCon.close();
        }
        this.listening = false;
    }
}

