/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.net;

import com.fazecast.jSerialComm.SerialPort;
import com.ghgande.j2mod.modbus.io.AbstractModbusTransport;
import com.ghgande.j2mod.modbus.io.ModbusASCIITransport;
import com.ghgande.j2mod.modbus.io.ModbusRTUTransport;
import com.ghgande.j2mod.modbus.io.ModbusSerialTransport;
import com.ghgande.j2mod.modbus.net.AbstractSerialConnection;
import com.ghgande.j2mod.modbus.util.SerialParameters;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialConnection
extends AbstractSerialConnection {
    private static final Logger logger = LoggerFactory.getLogger(SerialConnection.class);
    private SerialParameters parameters;
    private ModbusSerialTransport transport;
    private SerialPort serialPort;
    private InputStream inputStream;
    private int timeout = 3000;

    public SerialConnection() {
    }

    public SerialConnection(SerialParameters parameters) {
        this.parameters = parameters;
    }

    public static AbstractSerialConnection getCommPort(String commPort) {
        SerialConnection jSerialCommPort = new SerialConnection();
        jSerialCommPort.serialPort = SerialPort.getCommPort((String)commPort);
        return jSerialCommPort;
    }

    @Override
    public AbstractModbusTransport getModbusTransport() {
        return this.transport;
    }

    @Override
    public void open() throws IOException {
        if (this.serialPort == null) {
            this.serialPort = SerialPort.getCommPort((String)this.parameters.getPortName());
            if (this.serialPort.getDescriptivePortName().contains("Bad Port")) {
                this.serialPort = null;
                throw new IOException(String.format("Port %s is not a valid name for a port on this platform", this.parameters.getPortName()));
            }
        }
        this.serialPort.closePort();
        this.setConnectionParameters();
        if ("ascii".equals(this.parameters.getEncoding())) {
            this.transport = new ModbusASCIITransport();
        } else if ("rtu".equals(this.parameters.getEncoding())) {
            this.transport = new ModbusRTUTransport();
        } else {
            this.transport = new ModbusRTUTransport();
            logger.warn("Unknown transport encoding [{}] - reverting to RTU", (Object)this.parameters.getEncoding());
        }
        this.transport.setEcho(this.parameters.isEcho());
        this.transport.setTimeout(this.timeout);
        this.transport.setCommPort(this);
        if (!this.serialPort.openPort(this.parameters.getOpenDelay())) {
            this.close();
            Set<String> ports = this.getCommPorts();
            StringBuilder portList = new StringBuilder("<NONE>");
            if (!ports.isEmpty()) {
                portList = new StringBuilder();
                for (String port : ports) {
                    portList.append(portList.length() == 0 ? "" : ",").append(port);
                }
            }
            throw new IOException(String.format("Port [%s] cannot be opened or does not exist - Valid ports are: [%s]", this.parameters.getPortName(), portList.toString()));
        }
        this.inputStream = this.serialPort.getInputStream();
    }

    @Override
    public void setConnectionParameters() {
        if (this.serialPort != null) {
            this.serialPort.setComPortParameters(this.parameters.getBaudRate(), this.parameters.getDatabits(), this.parameters.getStopbits(), this.parameters.getParity());
            this.serialPort.setFlowControl(this.parameters.getFlowControlIn() | this.parameters.getFlowControlOut());
        }
    }

    @Override
    public void close() {
        if (this.serialPort != null) {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException e) {
                logger.debug(e.getMessage());
            }
            finally {
                this.serialPort.closePort();
            }
        }
        this.serialPort = null;
    }

    @Override
    public boolean isOpen() {
        return this.serialPort != null && this.serialPort.isOpen();
    }

    @Override
    public synchronized int getTimeout() {
        return this.timeout;
    }

    @Override
    public synchronized void setTimeout(int timeout) {
        this.timeout = timeout;
        if (this.transport != null) {
            this.transport.setTimeout(timeout);
        }
    }

    @Override
    public int readBytes(byte[] buffer, long bytesToRead) {
        return this.serialPort.readBytes(buffer, bytesToRead);
    }

    @Override
    public int writeBytes(byte[] buffer, long bytesToWrite) {
        return this.serialPort.writeBytes(buffer, bytesToWrite);
    }

    @Override
    public int bytesAvailable() {
        return this.serialPort.bytesAvailable();
    }

    @Override
    public int getBaudRate() {
        return this.serialPort.getBaudRate();
    }

    @Override
    public void setBaudRate(int newBaudRate) {
        this.serialPort.setBaudRate(newBaudRate);
    }

    @Override
    public int getNumDataBits() {
        return this.serialPort.getNumDataBits();
    }

    @Override
    public int getNumStopBits() {
        return this.serialPort.getNumStopBits();
    }

    @Override
    public int getParity() {
        return this.serialPort.getParity();
    }

    @Override
    public String getDescriptivePortName() {
        return this.serialPort == null ? "" : this.serialPort.getDescriptivePortName();
    }

    @Override
    public void setComPortTimeouts(int newTimeoutMode, int newReadTimeout, int newWriteTimeout) {
        if (this.serialPort != null) {
            this.serialPort.setComPortTimeouts(newTimeoutMode, newReadTimeout, newWriteTimeout);
        }
    }

    @Override
    public Set<String> getCommPorts() {
        TreeSet<String> returnValue = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        SerialPort[] ports = SerialPort.getCommPorts();
        if (ports != null && ports.length > 0) {
            for (SerialPort port : ports) {
                returnValue.add(port.getSystemPortName());
            }
        }
        return returnValue;
    }
}

