/*
 * Decompiled with CFR 0.152.
 */
package com.ghgande.j2mod.modbus.net;

import com.ghgande.j2mod.modbus.io.AbstractModbusTransport;
import com.ghgande.j2mod.modbus.io.ModbusRTUTCPTransport;
import com.ghgande.j2mod.modbus.io.ModbusTCPTransport;
import com.ghgande.j2mod.modbus.util.ModbusUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPMasterConnection {
    private static final Logger logger = LoggerFactory.getLogger(TCPMasterConnection.class);
    private Socket socket;
    private int timeout = 3000;
    private boolean connected;
    private InetAddress address;
    private int port = 502;
    private ModbusTCPTransport transport;
    private boolean useRtuOverTcp = false;
    private boolean useUrgentData = false;

    public TCPMasterConnection(InetAddress adr) {
        this.address = adr;
    }

    private void prepareTransport(boolean useRtuOverTcp) throws IOException {
        if (this.transport == null || this.useRtuOverTcp != useRtuOverTcp) {
            this.useRtuOverTcp = useRtuOverTcp;
            if (useRtuOverTcp) {
                logger.trace("prepareTransport() -> using RTU over TCP transport.");
                this.transport = new ModbusRTUTCPTransport(this.socket);
                this.transport.setMaster(this);
            } else {
                logger.trace("prepareTransport() -> using standard TCP transport.");
                this.transport = new ModbusTCPTransport(this.socket);
                this.transport.setMaster(this);
            }
        } else {
            logger.trace("prepareTransport() -> using custom transport: {}", (Object)this.transport.getClass().getSimpleName());
            this.transport.setSocket(this.socket);
        }
        this.transport.setTimeout(this.timeout);
    }

    public void connect() throws Exception {
        this.connect(this.useRtuOverTcp);
    }

    public void connect(boolean useRtuOverTcp) throws Exception {
        if (!this.isConnected()) {
            logger.debug("connect()");
            this.socket = new Socket();
            this.socket.setReuseAddress(true);
            this.socket.setSoLinger(true, 1);
            this.socket.setKeepAlive(true);
            this.setTimeout(this.timeout);
            this.socket.connect(new InetSocketAddress(this.address, this.port), this.timeout);
            this.prepareTransport(useRtuOverTcp);
            this.connected = true;
        }
    }

    public synchronized boolean isConnected() {
        if (this.connected && this.socket != null) {
            if (!this.socket.isConnected() || this.socket.isClosed() || this.socket.isInputShutdown() || this.socket.isOutputShutdown()) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    logger.error("Socket exception", (Throwable)e);
                }
                finally {
                    this.connected = false;
                }
            } else if (this.useUrgentData) {
                try {
                    this.socket.sendUrgentData(0);
                    ModbusUtil.sleep(5L);
                }
                catch (IOException e) {
                    this.connected = false;
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.connected;
    }

    public void close() {
        if (this.connected) {
            try {
                this.transport.close();
            }
            catch (IOException ex) {
                logger.debug("close()", (Throwable)ex);
            }
            finally {
                this.connected = false;
            }
        }
    }

    public AbstractModbusTransport getModbusTransport() {
        return this.transport;
    }

    public void setModbusTransport(ModbusTCPTransport trans) {
        this.transport = trans;
    }

    public synchronized int getTimeout() {
        return this.timeout;
    }

    public synchronized void setTimeout(int timeout) {
        try {
            this.timeout = timeout;
            if (this.socket != null) {
                this.socket.setSoTimeout(timeout);
            }
        }
        catch (IOException ex) {
            logger.warn("Could not set timeout to value " + timeout, (Throwable)ex);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress adr) {
        this.address = adr;
    }

    public boolean getUseUrgentData() {
        return this.useUrgentData;
    }

    public void setUseUrgentData(boolean useUrgentData) {
        this.useUrgentData = useUrgentData;
    }

    public boolean isUseRtuOverTcp() {
        return this.useRtuOverTcp;
    }

    public void setUseRtuOverTcp(boolean useRtuOverTcp) throws Exception {
        this.useRtuOverTcp = useRtuOverTcp;
        if (this.isConnected()) {
            this.prepareTransport(useRtuOverTcp);
        }
    }
}

