/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import java.util.List;
import me.chanjar.weixin.channel.api.WxChannelProductService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.base.WxChannelBaseResponse;
import me.chanjar.weixin.channel.bean.limit.LimitTaskAddResponse;
import me.chanjar.weixin.channel.bean.limit.LimitTaskListParam;
import me.chanjar.weixin.channel.bean.limit.LimitTaskListResponse;
import me.chanjar.weixin.channel.bean.limit.LimitTaskParam;
import me.chanjar.weixin.channel.bean.product.SkuStockBatchParam;
import me.chanjar.weixin.channel.bean.product.SkuStockBatchResponse;
import me.chanjar.weixin.channel.bean.product.SkuStockParam;
import me.chanjar.weixin.channel.bean.product.SkuStockResponse;
import me.chanjar.weixin.channel.bean.product.SpuFastInfo;
import me.chanjar.weixin.channel.bean.product.SpuGetResponse;
import me.chanjar.weixin.channel.bean.product.SpuInfo;
import me.chanjar.weixin.channel.bean.product.SpuListParam;
import me.chanjar.weixin.channel.bean.product.SpuListResponse;
import me.chanjar.weixin.channel.bean.product.SpuUpdateInfo;
import me.chanjar.weixin.channel.bean.product.SpuUpdateResponse;
import me.chanjar.weixin.channel.bean.product.link.ProductH5UrlResponse;
import me.chanjar.weixin.channel.bean.product.link.ProductQrCodeResponse;
import me.chanjar.weixin.channel.bean.product.link.ProductTagLinkResponse;
import me.chanjar.weixin.channel.util.JsonUtils;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelProductServiceImpl
implements WxChannelProductService {
    private static final Logger log = LoggerFactory.getLogger(WxChannelProductServiceImpl.class);
    private final BaseWxChannelServiceImpl<?, ?> shopService;

    public WxChannelProductServiceImpl(BaseWxChannelServiceImpl<?, ?> shopService) {
        this.shopService = shopService;
    }

    @Override
    public SpuUpdateResponse addProduct(SpuUpdateInfo info) throws WxErrorException {
        String reqJson = JsonUtils.encode(info);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/add", reqJson);
        return ResponseUtils.decode(resJson, SpuUpdateResponse.class);
    }

    @Override
    public SpuUpdateResponse updateProduct(SpuUpdateInfo info) throws WxErrorException {
        String reqJson = JsonUtils.encode(info);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/update", reqJson);
        return ResponseUtils.decode(resJson, SpuUpdateResponse.class);
    }

    @Override
    public SpuUpdateResponse addProduct(SpuInfo info) throws WxErrorException {
        String reqJson = JsonUtils.encode(info);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/add", reqJson);
        return ResponseUtils.decode(resJson, SpuUpdateResponse.class);
    }

    @Override
    public SpuUpdateResponse updateProduct(SpuInfo info) throws WxErrorException {
        String reqJson = JsonUtils.encode(info);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/update", reqJson);
        return ResponseUtils.decode(resJson, SpuUpdateResponse.class);
    }

    @Override
    public WxChannelBaseResponse updateProductAuditFree(SpuFastInfo info) throws WxErrorException {
        String reqJson = JsonUtils.encode(info);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/auditfree", reqJson);
        return ResponseUtils.decode(resJson, SpuUpdateResponse.class);
    }

    @Override
    public WxChannelBaseResponse updateStock(String productId, String skuId, Integer diffType, Integer num) throws WxErrorException {
        SkuStockParam param = new SkuStockParam(productId, skuId, diffType, num);
        String reqJson = JsonUtils.encode(param);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/stock/update", reqJson);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    protected String generateProductIdJson(String productId, Integer dataType) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        if (productId != null) {
            sb.append("\"product_id\":").append(productId);
        }
        if (dataType != null) {
            sb.append(",").append("\"data_type\":").append(dataType);
        }
        sb.append('}');
        return sb.toString();
    }

    protected WxChannelBaseResponse simpleProductRequest(String url, String productId) throws WxErrorException {
        String reqJson = this.generateProductIdJson(productId, null);
        String resJson = this.shopService.post(url, reqJson);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse deleteProduct(String productId) throws WxErrorException {
        return this.simpleProductRequest("https://api.weixin.qq.com/channels/ec/product/delete", productId);
    }

    @Override
    public WxChannelBaseResponse cancelProductAudit(String productId) throws WxErrorException {
        return this.simpleProductRequest("https://api.weixin.qq.com/channels/ec/product/audit/cancel", productId);
    }

    @Override
    public SpuGetResponse getProduct(String productId, Integer dataType) throws WxErrorException {
        String reqJson = this.generateProductIdJson(productId, dataType);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/get", reqJson);
        return ResponseUtils.decode(resJson, SpuGetResponse.class);
    }

    @Override
    public SpuListResponse listProduct(Integer pageSize, String nextKey, Integer status) throws WxErrorException {
        SpuListParam param = new SpuListParam(pageSize, nextKey, status);
        String reqJson = JsonUtils.encode(param);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/list/get", reqJson);
        return ResponseUtils.decode(resJson, SpuListResponse.class);
    }

    @Override
    public WxChannelBaseResponse upProduct(String productId) throws WxErrorException {
        return this.simpleProductRequest("https://api.weixin.qq.com/channels/ec/product/listing", productId);
    }

    @Override
    public WxChannelBaseResponse downProduct(String productId) throws WxErrorException {
        return this.simpleProductRequest("https://api.weixin.qq.com/channels/ec/product/delisting", productId);
    }

    @Override
    public SkuStockResponse getSkuStock(String productId, String skuId) throws WxErrorException {
        String reqJson = "{\"product_id\":\"" + productId + "\",\"sku_id\":\"" + skuId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/stock/get", reqJson);
        return ResponseUtils.decode(resJson, SkuStockResponse.class);
    }

    @Override
    public SkuStockBatchResponse getSkuStockBatch(List<String> productIds) throws WxErrorException {
        SkuStockBatchParam param = new SkuStockBatchParam(productIds);
        String reqJson = JsonUtils.encode(param);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/stock/batchget", reqJson);
        return ResponseUtils.decode(resJson, SkuStockBatchResponse.class);
    }

    @Override
    public ProductH5UrlResponse getProductH5Url(String productId) throws WxErrorException {
        String reqJson = "{\"product_id\":\"" + productId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/h5url/get", reqJson);
        return ResponseUtils.decode(resJson, ProductH5UrlResponse.class);
    }

    @Override
    public ProductQrCodeResponse getProductQrCode(String productId) throws WxErrorException {
        String reqJson = "{\"product_id\":\"" + productId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/qrcode/get", reqJson);
        return ResponseUtils.decode(resJson, ProductQrCodeResponse.class);
    }

    @Override
    public ProductTagLinkResponse getProductTagLink(String productId) throws WxErrorException {
        String reqJson = "{\"product_id\":\"" + productId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/taglink/get", reqJson);
        return ResponseUtils.decode(resJson, ProductTagLinkResponse.class);
    }

    @Override
    public LimitTaskAddResponse addLimitTask(LimitTaskParam param) throws WxErrorException {
        String reqJson = JsonUtils.encode(param);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/limiteddiscounttask/add", reqJson);
        return ResponseUtils.decode(resJson, LimitTaskAddResponse.class);
    }

    @Override
    public LimitTaskListResponse listLimitTask(Integer pageSize, String nextKey, Integer status) throws WxErrorException {
        LimitTaskListParam param = new LimitTaskListParam(pageSize, nextKey, status);
        String reqJson = JsonUtils.encode(param);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/limiteddiscounttask/list/get", reqJson);
        return ResponseUtils.decode(resJson, LimitTaskListResponse.class);
    }

    @Override
    public WxChannelBaseResponse stopLimitTask(String taskId) throws WxErrorException {
        String reqJson = "{\"task_id\": \"" + taskId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/limiteddiscounttask/stop", reqJson);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse deleteLimitTask(String taskId) throws WxErrorException {
        String reqJson = "{\"task_id\": \"" + taskId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/product/limiteddiscounttask/delete", reqJson);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }
}

