/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import me.chanjar.weixin.channel.api.WxChannelVipService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.base.WxChannelBaseResponse;
import me.chanjar.weixin.channel.bean.vip.VipGradeParam;
import me.chanjar.weixin.channel.bean.vip.VipInfoParam;
import me.chanjar.weixin.channel.bean.vip.VipInfoResponse;
import me.chanjar.weixin.channel.bean.vip.VipListParam;
import me.chanjar.weixin.channel.bean.vip.VipListResponse;
import me.chanjar.weixin.channel.bean.vip.VipOpenIdParam;
import me.chanjar.weixin.channel.bean.vip.VipScoreParam;
import me.chanjar.weixin.channel.bean.vip.VipScoreResponse;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelVipServiceImpl
implements WxChannelVipService {
    private static final Logger log = LoggerFactory.getLogger(WxChannelVipServiceImpl.class);
    private final BaseWxChannelServiceImpl<?, ?> shopService;

    public WxChannelVipServiceImpl(BaseWxChannelServiceImpl<?, ?> shopService) {
        this.shopService = shopService;
    }

    @Override
    public VipInfoResponse getVipInfo(String openId, Boolean needPhoneNumber) throws WxErrorException {
        VipInfoParam param = new VipInfoParam(openId, needPhoneNumber);
        String respJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/vip/user/info/get", param);
        return ResponseUtils.decode(respJson, VipInfoResponse.class);
    }

    @Override
    public VipListResponse getVipList(Boolean needPhoneNumber, Integer pageNum, Integer pageSize) throws WxErrorException {
        VipListParam param = new VipListParam(needPhoneNumber, pageNum, pageSize);
        String respJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/vip/user/list/get", param);
        return ResponseUtils.decode(respJson, VipListResponse.class);
    }

    @Override
    public VipScoreResponse getVipScore(String openId) throws WxErrorException {
        VipOpenIdParam param = new VipOpenIdParam(openId);
        String respJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/vip/user/score/get", param);
        return ResponseUtils.decode(respJson, VipScoreResponse.class);
    }

    @Override
    public WxChannelBaseResponse increaseVipScore(String openId, String score, String remark, String requestId) throws WxErrorException {
        VipScoreParam param = new VipScoreParam(openId, score, remark, requestId);
        String respJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/vip/user/score/increase", param);
        return ResponseUtils.decode(respJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse decreaseVipScore(String openId, String score, String remark, String requestId) throws WxErrorException {
        VipScoreParam param = new VipScoreParam(openId, score, remark, requestId);
        String respJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/vip/user/score/decrease", param);
        return ResponseUtils.decode(respJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse updateVipGrade(String openId, Integer score) throws WxErrorException {
        VipGradeParam param = new VipGradeParam(openId, score);
        String respJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/vip/user/grade/update", param);
        return ResponseUtils.decode(respJson, WxChannelBaseResponse.class);
    }
}

