/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import me.chanjar.weixin.channel.api.WxLeadComponentService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.lead.component.request.GetLeadInfoByComponentRequest;
import me.chanjar.weixin.channel.bean.lead.component.request.GetLeadsComponentIdRequest;
import me.chanjar.weixin.channel.bean.lead.component.request.GetLeadsComponentPromoteRecordRequest;
import me.chanjar.weixin.channel.bean.lead.component.request.GetLeadsInfoByRequestIdRequest;
import me.chanjar.weixin.channel.bean.lead.component.request.GetLeadsRequestIdRequest;
import me.chanjar.weixin.channel.bean.lead.component.response.GetLeadsComponentIdResponse;
import me.chanjar.weixin.channel.bean.lead.component.response.GetLeadsComponentPromoteRecordResponse;
import me.chanjar.weixin.channel.bean.lead.component.response.GetLeadsRequestIdResponse;
import me.chanjar.weixin.channel.bean.lead.component.response.LeadInfoResponse;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxLeadComponentServiceImpl
implements WxLeadComponentService {
    private static final Logger log = LoggerFactory.getLogger(WxLeadComponentServiceImpl.class);
    private final BaseWxChannelServiceImpl<?, ?> shopService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public LeadInfoResponse getLeadsInfoByComponentId(GetLeadInfoByComponentRequest req) throws WxErrorException {
        req.setVersion((Integer)ObjectUtils.defaultIfNull((Object)req.getVersion(), (Object)1));
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/leads/get_leads_info_by_component_id", req);
        return this.convertLeadInfoResponse(resJson);
    }

    @Override
    public LeadInfoResponse getLeadsInfoByRequestId(GetLeadsInfoByRequestIdRequest req) throws WxErrorException {
        req.setVersion((Integer)ObjectUtils.defaultIfNull((Object)req.getVersion(), (Object)1));
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/leads/get_leads_info_by_request_id", req);
        return this.convertLeadInfoResponse(resJson);
    }

    @Override
    public GetLeadsRequestIdResponse getLeadsRequestId(GetLeadsRequestIdRequest req) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/leads/get_leads_request_id", req);
        return ResponseUtils.decode(resJson, GetLeadsRequestIdResponse.class);
    }

    @Override
    public GetLeadsComponentPromoteRecordResponse getLeadsComponentPromoteRecord(GetLeadsComponentPromoteRecordRequest req) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/leads/get_leads_component_promote_record", req);
        return ResponseUtils.decode(resJson, GetLeadsComponentPromoteRecordResponse.class);
    }

    @Override
    public GetLeadsComponentIdResponse getLeadsComponentId(GetLeadsComponentIdRequest req) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/leads/get_leads_component_id", req);
        return ResponseUtils.decode(resJson, GetLeadsComponentIdResponse.class);
    }

    private LeadInfoResponse convertLeadInfoResponse(String resJson) throws WxErrorException {
        try {
            ObjectNode rootNode = (ObjectNode)this.objectMapper.readTree(resJson);
            ArrayNode convertedUserDataArray = this.objectMapper.createArrayNode();
            for (JsonNode userDataEle : rootNode.get("user_data")) {
                ObjectNode userDataJsonNode = (ObjectNode)this.objectMapper.readTree(userDataEle.asText());
                ArrayNode leadsDataArray = (ArrayNode)this.objectMapper.readTree(userDataJsonNode.get("leads_data").asText());
                userDataJsonNode.set("leads_data", (JsonNode)leadsDataArray);
                convertedUserDataArray.add((JsonNode)userDataJsonNode);
            }
            rootNode.set("user_data", (JsonNode)convertedUserDataArray);
            String json = this.objectMapper.writeValueAsString((Object)rootNode);
            return ResponseUtils.decode(json, LeadInfoResponse.class);
        }
        catch (JsonProcessingException e) {
            throw new WxErrorException((Throwable)e);
        }
    }

    public WxLeadComponentServiceImpl(BaseWxChannelServiceImpl<?, ?> shopService) {
        this.shopService = shopService;
    }
}

