/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import me.chanjar.weixin.channel.api.WxLeagueSupplierService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.base.StreamPageParam;
import me.chanjar.weixin.channel.bean.league.supplier.CommissionOrderListParam;
import me.chanjar.weixin.channel.bean.league.supplier.CommissionOrderListResponse;
import me.chanjar.weixin.channel.bean.league.supplier.CommissionOrderResponse;
import me.chanjar.weixin.channel.bean.league.supplier.CoopProductDetailParam;
import me.chanjar.weixin.channel.bean.league.supplier.CoopProductListParam;
import me.chanjar.weixin.channel.bean.league.supplier.CoopProductListResponse;
import me.chanjar.weixin.channel.bean.league.supplier.CoopProductResponse;
import me.chanjar.weixin.channel.bean.league.supplier.FlowListParam;
import me.chanjar.weixin.channel.bean.league.supplier.ShopDetailResponse;
import me.chanjar.weixin.channel.bean.league.supplier.ShopListResponse;
import me.chanjar.weixin.channel.bean.league.supplier.SupplierBalanceResponse;
import me.chanjar.weixin.channel.bean.league.supplier.SupplierFlowDetailResponse;
import me.chanjar.weixin.channel.bean.league.supplier.SupplierFlowListResponse;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxLeagueSupplierServiceImpl
implements WxLeagueSupplierService {
    private static final Logger log = LoggerFactory.getLogger(WxLeagueSupplierServiceImpl.class);
    private final BaseWxChannelServiceImpl<?, ?> shopService;

    public WxLeagueSupplierServiceImpl(BaseWxChannelServiceImpl<?, ?> shopService) {
        this.shopService = shopService;
    }

    @Override
    public SupplierBalanceResponse getBalanceInfo() throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/headsupplier/funds/balance/get", "{}");
        return ResponseUtils.decode(resJson, SupplierBalanceResponse.class);
    }

    @Override
    public SupplierFlowDetailResponse getFlowDetail(String flowId) throws WxErrorException {
        String reqJson = "{\"flow_id\":\"" + flowId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/headsupplier/funds/flowdetail/get", reqJson);
        return ResponseUtils.decode(resJson, SupplierFlowDetailResponse.class);
    }

    @Override
    public SupplierFlowListResponse getFlowList(FlowListParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/headsupplier/funds/flowlist/get", param);
        return ResponseUtils.decode(resJson, SupplierFlowListResponse.class);
    }

    @Override
    public CoopProductResponse getProductDetail(String productId, String appId) throws WxErrorException {
        CoopProductDetailParam param = new CoopProductDetailParam(productId, appId);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/headsupplier/item/get", param);
        return ResponseUtils.decode(resJson, CoopProductResponse.class);
    }

    @Override
    public CoopProductListResponse getProductList(String appid, Integer pageSize, String nextKey) throws WxErrorException {
        CoopProductListParam param = new CoopProductListParam(appid, pageSize, nextKey);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/headsupplier/item/list/get", param);
        return ResponseUtils.decode(resJson, CoopProductListResponse.class);
    }

    @Override
    public CommissionOrderResponse getCommissionOrder(String orderId, String skuId) throws WxErrorException {
        String reqJson = "{\"order_id\":\"" + orderId + "\",\"sku_id\":\"" + skuId + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/headsupplier/order/get", reqJson);
        return ResponseUtils.decode(resJson, CommissionOrderResponse.class);
    }

    @Override
    public CommissionOrderListResponse getCommissionOrderList(CommissionOrderListParam param) throws WxErrorException {
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/headsupplier/order/list/get", param);
        return ResponseUtils.decode(resJson, CommissionOrderListResponse.class);
    }

    @Override
    public ShopDetailResponse getShopDetail(String appid) throws WxErrorException {
        String reqJson = "{\"appid\":\"" + appid + "\"}";
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/headsupplier/shop/get", reqJson);
        return ResponseUtils.decode(resJson, ShopDetailResponse.class);
    }

    @Override
    public ShopListResponse getShopList(Integer pageSize, String nextKey) throws WxErrorException {
        StreamPageParam param = new StreamPageParam(pageSize, nextKey);
        String resJson = this.shopService.post("https://api.weixin.qq.com/channels/ec/league/headsupplier/shop/list/get", param);
        return ResponseUtils.decode(resJson, ShopListResponse.class);
    }
}

