/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.api.impl;

import me.chanjar.weixin.channel.api.WxStoreCooperationService;
import me.chanjar.weixin.channel.api.impl.BaseWxChannelServiceImpl;
import me.chanjar.weixin.channel.bean.base.WxChannelBaseResponse;
import me.chanjar.weixin.channel.bean.cooperation.CooperationListResponse;
import me.chanjar.weixin.channel.bean.cooperation.CooperationQrCodeResponse;
import me.chanjar.weixin.channel.bean.cooperation.CooperationSharerParam;
import me.chanjar.weixin.channel.bean.cooperation.CooperationStatusResponse;
import me.chanjar.weixin.channel.util.ResponseUtils;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxStoreCooperationServiceImpl
implements WxStoreCooperationService {
    private static final Logger log = LoggerFactory.getLogger(WxStoreCooperationServiceImpl.class);
    private final BaseWxChannelServiceImpl<?, ?> storeService;

    public WxStoreCooperationServiceImpl(BaseWxChannelServiceImpl<?, ?> storeService) {
        this.storeService = storeService;
    }

    @Override
    public CooperationListResponse listCooperation(Integer sharerType) throws WxErrorException {
        String paramJson = "{\"sharer_type\":" + sharerType + "}";
        String resJson = this.storeService.post("https://api.weixin.qq.com/channels/ec/cooperation/list", paramJson);
        return ResponseUtils.decode(resJson, CooperationListResponse.class);
    }

    @Override
    public CooperationStatusResponse getCooperationStatus(String sharerId, Integer sharerType) throws WxErrorException {
        CooperationSharerParam param = new CooperationSharerParam(sharerId, sharerType);
        String resJson = this.storeService.post("https://api.weixin.qq.com/channels/ec/cooperation/invitation/get", param);
        return ResponseUtils.decode(resJson, CooperationStatusResponse.class);
    }

    @Override
    public CooperationQrCodeResponse generateQrCode(String sharerId, Integer sharerType) throws WxErrorException {
        CooperationSharerParam param = new CooperationSharerParam(sharerId, sharerType);
        String resJson = this.storeService.post("https://api.weixin.qq.com/channels/ec/cooperation/invitation/qrcode/generate", param);
        return ResponseUtils.decode(resJson, CooperationQrCodeResponse.class);
    }

    @Override
    public WxChannelBaseResponse cancelInvitation(String sharerId, Integer sharerType) throws WxErrorException {
        CooperationSharerParam param = new CooperationSharerParam(sharerId, sharerType);
        String resJson = this.storeService.post("https://api.weixin.qq.com/channels/ec/cooperation/invitation/cancel", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }

    @Override
    public WxChannelBaseResponse unbind(String sharerId, Integer sharerType) throws WxErrorException {
        CooperationSharerParam param = new CooperationSharerParam(sharerId, sharerType);
        String resJson = this.storeService.post("https://api.weixin.qq.com/channels/ec/cooperation/unbind", param);
        return ResponseUtils.decode(resJson, WxChannelBaseResponse.class);
    }
}

