/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.config.impl;

import java.util.concurrent.TimeUnit;
import me.chanjar.weixin.channel.config.impl.WxChannelDefaultConfigImpl;
import me.chanjar.weixin.common.redis.WxRedisOps;

public class WxChannelRedisConfigImpl
extends WxChannelDefaultConfigImpl {
    private static final String ACCESS_TOKEN_KEY_TPL = "%s:access_token:%s";
    private static final String LOCK_KEY_TPL = "%s:lock:%s:";
    private final WxRedisOps redisOps;
    private final String keyPrefix;
    private volatile String accessTokenKey;
    private volatile String lockKey;

    public WxChannelRedisConfigImpl(WxRedisOps redisOps, String keyPrefix) {
        this.redisOps = redisOps;
        this.keyPrefix = keyPrefix;
    }

    @Override
    public void setAppid(String appId) {
        super.setAppid(appId);
        this.accessTokenKey = String.format(ACCESS_TOKEN_KEY_TPL, this.keyPrefix, appId);
        this.lockKey = String.format(LOCK_KEY_TPL, this.keyPrefix, appId);
        this.accessTokenLock = this.redisOps.getLock(this.lockKey.concat("accessTokenLock"));
    }

    @Override
    public String getAccessToken() {
        return this.redisOps.getValue(this.accessTokenKey);
    }

    @Override
    public boolean isAccessTokenExpired() {
        Long expire = this.redisOps.getExpire(this.accessTokenKey);
        return expire == null || expire < 2L;
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.redisOps.setValue(this.accessTokenKey, accessToken, expiresInSeconds - 200, TimeUnit.SECONDS);
    }

    @Override
    public void expireAccessToken() {
        this.redisOps.expire(this.accessTokenKey, 0, TimeUnit.SECONDS);
    }

    @Override
    public String toString() {
        return "WxChannelRedisConfigImpl{appid='" + this.appid + '\'' + ", token='" + this.token + '\'' + ", accessTokenLock=" + this.accessTokenLock + ", tmpDirFile=" + this.tmpDirFile + ", redisOps=" + this.redisOps + ", keyPrefix='" + this.keyPrefix + '\'' + ", accessTokenKey='" + this.accessTokenKey + '\'' + ", lockKey='" + this.lockKey + '\'' + '}';
    }
}

