/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.config.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import lombok.NonNull;
import me.chanjar.weixin.channel.config.impl.WxChannelDefaultConfigImpl;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.redis.RedissonWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;

public class WxChannelRedissonConfigImpl
extends WxChannelDefaultConfigImpl {
    protected static final String LOCK_KEY = "wx_channel_lock:";
    protected static final String MA_ACCESS_TOKEN_KEY = "wx_channel_access_token_key:";
    protected String keyPrefix;
    protected String accessTokenKey;
    protected String lockKey;
    private final WxRedisOps redisOps;

    public WxChannelRedissonConfigImpl(@NonNull RedissonClient redissonClient, String keyPrefix) {
        this((WxRedisOps)new RedissonWxRedisOps(redissonClient), keyPrefix);
        if (redissonClient == null) {
            throw new NullPointerException("redissonClient is marked non-null but is null");
        }
    }

    public WxChannelRedissonConfigImpl(@NonNull RedissonClient redissonClient) {
        this(redissonClient, null);
        if (redissonClient == null) {
            throw new NullPointerException("redissonClient is marked non-null but is null");
        }
    }

    private WxChannelRedissonConfigImpl(@NonNull WxRedisOps redisOps, String keyPrefix) {
        if (redisOps == null) {
            throw new NullPointerException("redisOps is marked non-null but is null");
        }
        this.redisOps = redisOps;
        this.keyPrefix = keyPrefix;
    }

    @Override
    public void setAppid(String appid) {
        super.setAppid(appid);
        String prefix = StringUtils.isBlank((CharSequence)this.keyPrefix) ? "" : (StringUtils.endsWith((CharSequence)this.keyPrefix, (CharSequence)":") ? this.keyPrefix : this.keyPrefix + ":");
        this.lockKey = prefix + LOCK_KEY.concat(appid);
        this.accessTokenKey = prefix + MA_ACCESS_TOKEN_KEY.concat(appid);
    }

    protected Lock getLockByKey(String key) {
        return this.redisOps.getLock(key);
    }

    @Override
    public Lock getAccessTokenLock() {
        return this.getLockByKey(this.lockKey.concat(":").concat("accessToken"));
    }

    @Override
    public String getAccessToken() {
        return this.redisOps.getValue(this.accessTokenKey);
    }

    @Override
    public boolean isAccessTokenExpired() {
        Long expire = this.redisOps.getExpire(this.accessTokenKey);
        return expire == null || expire < 2L;
    }

    @Override
    public void updateAccessToken(WxAccessToken accessToken) {
        this.redisOps.setValue(this.accessTokenKey, accessToken.getAccessToken(), accessToken.getExpiresIn(), TimeUnit.SECONDS);
    }

    @Override
    public void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.redisOps.setValue(this.accessTokenKey, accessToken, expiresInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void expireAccessToken() {
        this.redisOps.expire(this.accessTokenKey, 0, TimeUnit.SECONDS);
    }
}

