/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.executor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.chanjar.weixin.channel.bean.image.ChannelImageResponse;
import me.chanjar.weixin.channel.executor.ApacheHttpChannelMediaDownloadRequestExecutor;
import me.chanjar.weixin.channel.executor.HttpComponentsChannelMediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.http.HttpHost;

public abstract class ChannelMediaDownloadRequestExecutor<H, P>
implements RequestExecutor<ChannelImageResponse, String> {
    protected RequestHttp<H, P> requestHttp;
    protected File tmpDirFile;
    private static final Pattern PATTERN = Pattern.compile(".*filename=\"(.*)\"");

    public ChannelMediaDownloadRequestExecutor(RequestHttp<H, P> requestHttp, File tmpDirFile) {
        this.requestHttp = requestHttp;
        this.tmpDirFile = tmpDirFile;
    }

    public static RequestExecutor<ChannelImageResponse, String> create(RequestHttp<?, ?> requestHttp, File tmpDirFile) {
        switch (requestHttp.getRequestType()) {
            case APACHE_HTTP: {
                return new ApacheHttpChannelMediaDownloadRequestExecutor((RequestHttp<org.apache.http.impl.client.CloseableHttpClient, HttpHost>)requestHttp, tmpDirFile);
            }
            case HTTP_COMPONENTS: {
                return new HttpComponentsChannelMediaDownloadRequestExecutor((RequestHttp<CloseableHttpClient, org.apache.hc.core5.http.HttpHost>)requestHttp, tmpDirFile);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684http\u6267\u884c\u5668\u7c7b\u578b\uff1a" + requestHttp.getRequestType());
    }

    public static File createTmpFile(InputStream inputStream, String name, String ext, File tmpDirFile) throws IOException {
        File resultFile = File.createTempFile(name, '.' + ext, tmpDirFile);
        resultFile.deleteOnExit();
        try (InputStream in = inputStream;
             FileOutputStream out = FileUtils.openOutputStream((File)resultFile);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        return resultFile;
    }

    protected String createDefaultFileName() {
        return UUID.randomUUID().toString();
    }

    protected String extractFileNameFromContentString(String content) {
        if (content == null || content.isEmpty()) {
            return this.createDefaultFileName();
        }
        Matcher m = PATTERN.matcher(content);
        if (m.matches()) {
            return m.group(1);
        }
        return this.createDefaultFileName();
    }
}

