/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.channel.message;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.channel.api.WxChannelService;
import me.chanjar.weixin.channel.enums.MessageType;
import me.chanjar.weixin.channel.message.WxChannelMessage;
import me.chanjar.weixin.channel.message.rule.WxChannelMessageHandler;
import me.chanjar.weixin.channel.message.rule.WxChannelMessageInterceptor;
import me.chanjar.weixin.channel.message.rule.WxChannelMessageMatcher;
import me.chanjar.weixin.channel.util.JsonUtils;
import me.chanjar.weixin.channel.util.XmlUtils;
import me.chanjar.weixin.common.api.WxErrorExceptionHandler;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxChannelMessageRouterRule<T extends WxChannelMessage> {
    private static final Logger log = LoggerFactory.getLogger(WxChannelMessageRouterRule.class);
    private boolean async = true;
    private String msgType;
    private String event;
    private WxChannelMessageMatcher matcher;
    private boolean next = false;
    private List<WxChannelMessageHandler<T>> handlers = new ArrayList<WxChannelMessageHandler<T>>(4);
    private List<WxChannelMessageInterceptor> interceptors = new ArrayList<WxChannelMessageInterceptor>(4);
    private Class<T> messageClass;

    public WxChannelMessageRouterRule<T> setEvent(String event) {
        this.msgType = MessageType.EVENT.getKey();
        this.event = event;
        return this;
    }

    protected boolean isMatch(WxChannelMessage message) {
        String msgType = message.getMsgType() == null ? null : message.getMsgType().toLowerCase();
        String event = message.getEvent() == null ? null : message.getEvent().toLowerCase();
        boolean matchMsgType = this.msgType == null || this.msgType.toLowerCase().equals(msgType);
        boolean matchEvent = this.event == null || this.event.toLowerCase().equals(event);
        boolean matchMatcher = this.matcher == null || this.matcher.match(message);
        return matchMsgType && matchEvent && matchMatcher;
    }

    protected Object process(WxChannelMessage message, String content, String appId, Map<String, Object> context, WxChannelService service, WxSessionManager sessionManager, WxErrorExceptionHandler exceptionHandler) {
        T tempMessage;
        if (context == null) {
            context = new HashMap<String, Object>(16);
        }
        if ((tempMessage = this.deserialize(content, this.messageClass, service)) == null) {
            log.error("\u6d88\u606f\u91cd\u65b0\u53cd\u5e8f\u5217\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6d88\u606f\u683c\u5f0f\u662f\u5426\u6b63\u786e\u6216\u8005\u6307\u5b9a\u6b63\u786e\u7684messageClass");
            return null;
        }
        Object outMessage = null;
        try {
            for (WxChannelMessageInterceptor wxChannelMessageInterceptor : this.interceptors) {
                if (wxChannelMessageInterceptor.intercept(message, content, context, service, sessionManager)) continue;
                return null;
            }
            for (WxChannelMessageHandler wxChannelMessageHandler : this.handlers) {
                if (wxChannelMessageHandler == null) continue;
                outMessage = wxChannelMessageHandler.handle(tempMessage, content, appId, context, sessionManager);
            }
        }
        catch (WxErrorException e) {
            exceptionHandler.handle(e);
        }
        return outMessage;
    }

    private T deserialize(String content, Class<T> clazz, WxChannelService service) {
        String msgFormat = service.getConfig().getMsgDataFormat();
        T t = this.deserialize(content, clazz, msgFormat);
        if (t != null) {
            return t;
        }
        if (StringUtils.isNotBlank((CharSequence)content)) {
            if (content.startsWith("<xml>")) {
                t = this.deserialize(content, clazz, "XML");
            } else if (content.startsWith("{")) {
                t = this.deserialize(content, clazz, "JSON");
            }
        }
        return t;
    }

    private T deserialize(String content, Class<T> clazz, String msgFormat) {
        WxChannelMessage message = null;
        message = msgFormat == null || msgFormat.equalsIgnoreCase("JSON") ? (WxChannelMessage)JsonUtils.decode(content, clazz) : (WxChannelMessage)XmlUtils.decode(content, clazz);
        return (T)message;
    }

    public boolean isAsync() {
        return this.async;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getEvent() {
        return this.event;
    }

    public WxChannelMessageMatcher getMatcher() {
        return this.matcher;
    }

    public boolean isNext() {
        return this.next;
    }

    public List<WxChannelMessageHandler<T>> getHandlers() {
        return this.handlers;
    }

    public List<WxChannelMessageInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public Class<T> getMessageClass() {
        return this.messageClass;
    }

    public WxChannelMessageRouterRule<T> setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public WxChannelMessageRouterRule<T> setMsgType(String msgType) {
        this.msgType = msgType;
        return this;
    }

    public WxChannelMessageRouterRule<T> setMatcher(WxChannelMessageMatcher matcher) {
        this.matcher = matcher;
        return this;
    }

    public WxChannelMessageRouterRule<T> setNext(boolean next) {
        this.next = next;
        return this;
    }

    public WxChannelMessageRouterRule<T> setHandlers(List<WxChannelMessageHandler<T>> handlers) {
        this.handlers = handlers;
        return this;
    }

    public WxChannelMessageRouterRule<T> setInterceptors(List<WxChannelMessageInterceptor> interceptors) {
        this.interceptors = interceptors;
        return this;
    }

    public WxChannelMessageRouterRule<T> setMessageClass(Class<T> messageClass) {
        this.messageClass = messageClass;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxChannelMessageRouterRule)) {
            return false;
        }
        WxChannelMessageRouterRule other = (WxChannelMessageRouterRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAsync() != other.isAsync()) {
            return false;
        }
        if (this.isNext() != other.isNext()) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        WxChannelMessageMatcher this$matcher = this.getMatcher();
        WxChannelMessageMatcher other$matcher = other.getMatcher();
        if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
            return false;
        }
        List<WxChannelMessageHandler<T>> this$handlers = this.getHandlers();
        List<WxChannelMessageHandler<T>> other$handlers = other.getHandlers();
        if (this$handlers == null ? other$handlers != null : !((Object)this$handlers).equals(other$handlers)) {
            return false;
        }
        List<WxChannelMessageInterceptor> this$interceptors = this.getInterceptors();
        List<WxChannelMessageInterceptor> other$interceptors = other.getInterceptors();
        if (this$interceptors == null ? other$interceptors != null : !((Object)this$interceptors).equals(other$interceptors)) {
            return false;
        }
        Class<T> this$messageClass = this.getMessageClass();
        Class<T> other$messageClass = other.getMessageClass();
        return !(this$messageClass == null ? other$messageClass != null : !this$messageClass.equals(other$messageClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxChannelMessageRouterRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAsync() ? 79 : 97);
        result = result * 59 + (this.isNext() ? 79 : 97);
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        WxChannelMessageMatcher $matcher = this.getMatcher();
        result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
        List<WxChannelMessageHandler<T>> $handlers = this.getHandlers();
        result = result * 59 + ($handlers == null ? 43 : ((Object)$handlers).hashCode());
        List<WxChannelMessageInterceptor> $interceptors = this.getInterceptors();
        result = result * 59 + ($interceptors == null ? 43 : ((Object)$interceptors).hashCode());
        Class<T> $messageClass = this.getMessageClass();
        result = result * 59 + ($messageClass == null ? 43 : $messageClass.hashCode());
        return result;
    }

    public String toString() {
        return "WxChannelMessageRouterRule(async=" + this.isAsync() + ", msgType=" + this.getMsgType() + ", event=" + this.getEvent() + ", matcher=" + this.getMatcher() + ", next=" + this.isNext() + ", handlers=" + this.getHandlers() + ", interceptors=" + this.getInterceptors() + ", messageClass=" + this.getMessageClass() + ")";
    }
}

