/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.executor;

import java.io.IOException;
import jodd.http.HttpConnectionProvider;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.bean.CommonUploadParam;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.executor.CommonUploadRequestExecutorApacheImpl;
import me.chanjar.weixin.common.executor.CommonUploadRequestExecutorHttpComponentsImpl;
import me.chanjar.weixin.common.executor.CommonUploadRequestExecutorJoddHttpImpl;
import me.chanjar.weixin.common.executor.CommonUploadRequestExecutorOkHttpImpl;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.ResponseHandler;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import okhttp3.OkHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.HttpHost;

public abstract class CommonUploadRequestExecutor<H, P>
implements RequestExecutor<String, CommonUploadParam> {
    protected RequestHttp<H, P> requestHttp;

    public CommonUploadRequestExecutor(RequestHttp<H, P> requestHttp) {
        this.requestHttp = requestHttp;
    }

    @Override
    public void execute(String uri, CommonUploadParam data, ResponseHandler<String> handler, WxType wxType) throws WxErrorException, IOException {
        handler.handle((String)this.execute(uri, data, wxType));
    }

    public static RequestExecutor<String, CommonUploadParam> create(RequestHttp<?, ?> requestHttp) {
        switch (requestHttp.getRequestType()) {
            case APACHE_HTTP: {
                return new CommonUploadRequestExecutorApacheImpl(requestHttp);
            }
            case JODD_HTTP: {
                return new CommonUploadRequestExecutorJoddHttpImpl((RequestHttp<HttpConnectionProvider, ProxyInfo>)requestHttp);
            }
            case OK_HTTP: {
                return new CommonUploadRequestExecutorOkHttpImpl((RequestHttp<OkHttpClient, OkHttpProxyInfo>)requestHttp);
            }
            case HTTP_COMPONENTS: {
                return new CommonUploadRequestExecutorHttpComponentsImpl((RequestHttp<CloseableHttpClient, HttpHost>)requestHttp);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684http\u6267\u884c\u5668\u7c7b\u578b\uff1a" + (Object)((Object)requestHttp.getRequestType()));
    }
}

