/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.requestexecuter.ocr;

import java.io.File;
import java.io.IOException;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.requestexecuter.ocr.OcrDiscernRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.hc.Utf8ResponseHandler;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;

public class OcrDiscernHttpComponentsRequestExecutor
extends OcrDiscernRequestExecutor<CloseableHttpClient, HttpHost> {
    public OcrDiscernHttpComponentsRequestExecutor(RequestHttp<CloseableHttpClient, HttpHost> requestHttp) {
        super(requestHttp);
    }

    @Override
    public String execute(String uri, File file, WxType wxType) throws WxErrorException, IOException {
        String responseContent;
        WxError error;
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(config);
        }
        if (file != null) {
            HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody("file", file).setMode(HttpMultipartMode.EXTENDED).build();
            httpPost.setEntity(entity);
        }
        if ((error = WxError.fromJson(responseContent = (String)((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((ClassicHttpRequest)httpPost, Utf8ResponseHandler.INSTANCE), wxType)).getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return responseContent;
    }
}

